/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.util;

import java.text.DecimalFormat;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import serverutils.ServerUtilitiesConfig;

public class MOTDFormatter {
    private static final DecimalFormat TPS_FORMAT = new DecimalFormat("0.0");
    private static final DecimalFormat MEMORY_FORMAT = new DecimalFormat("0");
    private static long serverStartTime = 0L;

    public static IChatComponent buildMOTD(MinecraftServer server) {
        if (serverStartTime == 0L) {
            serverStartTime = System.currentTimeMillis();
        }
        if (!ServerUtilitiesConfig.motd.enabled) {
            return new ChatComponentText(server.func_71273_Y());
        }
        String line1 = MOTDFormatter.processVariables(ServerUtilitiesConfig.motd.line1, server);
        String line2 = MOTDFormatter.processVariables(ServerUtilitiesConfig.motd.line2, server);
        String combinedText = line1 + "\n" + line2;
        return new ChatComponentText(combinedText);
    }

    private static String processVariables(String text, MinecraftServer server) {
        String result = text;
        result = result.replace("{players}", String.valueOf(server.func_71233_x()));
        result = result.replace("{maxPlayers}", String.valueOf(server.func_71275_y()));
        if ((result = result.replace("{tps}", MOTDFormatter.calculateTPS(server))).contains("{memory}")) {
            Runtime runtime = Runtime.getRuntime();
            long maxMemory = runtime.maxMemory() / 1024L / 1024L;
            long totalMemory = runtime.totalMemory() / 1024L / 1024L;
            long freeMemory = runtime.freeMemory() / 1024L / 1024L;
            long usedMemory = totalMemory - freeMemory;
            result = result.replace("{memory}", MEMORY_FORMAT.format(usedMemory) + "/" + MEMORY_FORMAT.format(maxMemory) + "MB");
        }
        if (result.contains("{uptime}")) {
            long uptimeMillis = System.currentTimeMillis() - serverStartTime;
            result = result.replace("{uptime}", MOTDFormatter.formatUptime(uptimeMillis));
        }
        return result;
    }

    private static String calculateTPS(MinecraftServer server) {
        try {
            long[] tickTimes = server.field_71311_j;
            double avgTickTimeNanos = MathHelper.func_76127_a((long[])tickTimes);
            double avgTickTimeMs = avgTickTimeNanos * 1.0E-6;
            double tps = Math.min(20.0, 1000.0 / avgTickTimeMs);
            return TPS_FORMAT.format(tps);
        }
        catch (Exception e) {
            return "N/A";
        }
    }

    private static String formatUptime(long uptimeMillis) {
        long seconds = uptimeMillis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        if (days > 0L) {
            return days + "d " + hours % 24L + "h";
        }
        if (hours > 0L) {
            return hours + "h " + minutes % 60L + "m";
        }
        if (minutes > 0L) {
            return minutes + "m";
        }
        return seconds + "s";
    }
}

