/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.util.text_components;

import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.misc.NameMap;

public class TextComponentParser {
    public static final NameMap.ObjectProperties<EnumChatFormatting> TEXT_FORMATTING_OBJECT_PROPERTIES = new NameMap.ObjectProperties<EnumChatFormatting>(){

        @Override
        public String getName(EnumChatFormatting value) {
            return value.func_96297_d();
        }

        @Override
        public IChatComponent getDisplayName(@Nullable ICommandSender sender, EnumChatFormatting value) {
            return StringUtils.color((IChatComponent)new ChatComponentText(this.getName(value)), value);
        }
    };
    public static final NameMap<EnumChatFormatting> TEXT_FORMATTING_NAME_MAP = NameMap.create(EnumChatFormatting.RESET, TEXT_FORMATTING_OBJECT_PROPERTIES, EnumChatFormatting.values());
    public static final NameMap<EnumChatFormatting> TEXT_FORMATTING_COLORS_NAME_MAP = NameMap.create(EnumChatFormatting.WHITE, TEXT_FORMATTING_OBJECT_PROPERTIES, new EnumChatFormatting[]{EnumChatFormatting.BLACK, EnumChatFormatting.DARK_BLUE, EnumChatFormatting.DARK_GREEN, EnumChatFormatting.DARK_AQUA, EnumChatFormatting.DARK_RED, EnumChatFormatting.DARK_PURPLE, EnumChatFormatting.GOLD, EnumChatFormatting.GRAY, EnumChatFormatting.DARK_GRAY, EnumChatFormatting.BLUE, EnumChatFormatting.GREEN, EnumChatFormatting.AQUA, EnumChatFormatting.RED, EnumChatFormatting.LIGHT_PURPLE, EnumChatFormatting.YELLOW, EnumChatFormatting.WHITE});
    public static final HashMap<Character, EnumChatFormatting> CODE_TO_FORMATTING = new HashMap();
    private final String text;
    private final Function<String, IChatComponent> substitutes;
    private IChatComponent component;
    private StringBuilder builder;
    private ChatStyle style;

    public static IChatComponent parse(String text, @Nullable Function<String, IChatComponent> substitutes) {
        return new TextComponentParser(text, substitutes).parse();
    }

    private TextComponentParser(String txt, @Nullable Function<String, IChatComponent> sub) {
        this.text = txt;
        this.substitutes = sub;
    }

    private IChatComponent parse() {
        if (this.text.isEmpty()) {
            return new ChatComponentText("");
        }
        char[] c = this.text.toCharArray();
        boolean hasSpecialCodes = false;
        for (char c1 : c) {
            if (c1 != '{' && c1 != '&' && c1 != '\u00a7') continue;
            hasSpecialCodes = true;
            break;
        }
        if (!hasSpecialCodes) {
            return new ChatComponentText(this.text);
        }
        this.component = new ChatComponentText("");
        this.style = new ChatStyle();
        this.builder = new StringBuilder();
        boolean sub = false;
        for (int i = 0; i < c.length; ++i) {
            boolean end;
            boolean escape = i > 0 && c[i - 1] == '\\';
            boolean bl = end = i == c.length - 1;
            if (sub && (end || c[i] == '{' || c[i] == '}')) {
                if (c[i] == '{') {
                    throw new IllegalArgumentException("Invalid formatting! Can't nest multiple substitutes!");
                }
                this.finishPart();
                sub = false;
                continue;
            }
            if (!escape) {
                char prev = c[i];
                if (c[i] == '&') {
                    c[i] = 167;
                }
                if (c[i] == '\u00a7') {
                    if (end || i + 1 >= c.length) {
                        this.builder.append(prev);
                        break;
                    }
                    EnumChatFormatting formatting = CODE_TO_FORMATTING.get(Character.valueOf(c[i + 1]));
                    if (formatting == null) {
                        this.builder.append(prev);
                        continue;
                    }
                    this.finishPart();
                    ++i;
                    switch (formatting) {
                        case OBFUSCATED: {
                            this.style.func_150237_e(Boolean.valueOf(!this.style.func_150233_f()));
                            break;
                        }
                        case BOLD: {
                            this.style.func_150227_a(Boolean.valueOf(!this.style.func_150223_b()));
                            break;
                        }
                        case STRIKETHROUGH: {
                            this.style.func_150225_c(Boolean.valueOf(!this.style.func_150236_d()));
                            break;
                        }
                        case UNDERLINE: {
                            this.style.func_150228_d(Boolean.valueOf(!this.style.func_150234_e()));
                            break;
                        }
                        case ITALIC: {
                            this.style.func_150217_b(Boolean.valueOf(!this.style.func_150242_c()));
                            break;
                        }
                        case RESET: {
                            this.style = new ChatStyle();
                            break;
                        }
                        default: {
                            this.style.func_150238_a(formatting);
                            break;
                        }
                    }
                    continue;
                }
                if (c[i] == '{') {
                    if (end) {
                        this.builder.append(c[i]);
                        break;
                    }
                    this.finishPart();
                    sub = true;
                }
            }
            if (c[i] == '\\' && !escape) continue;
            this.builder.append(c[i]);
        }
        this.finishPart();
        return this.component;
    }

    private void finishPart() {
        String string = this.builder.toString();
        this.builder.setLength(0);
        if (string.isEmpty()) {
            return;
        }
        ChatComponentText component1 = new ChatComponentText(string);
        if (string.length() < 2 || string.charAt(0) != '{') {
            component1.func_150255_a(this.style.func_150232_l());
            this.component.func_150257_a((IChatComponent)component1);
            return;
        }
        if (this.substitutes != null) {
            component1 = this.substitutes.apply(string.substring(1));
        }
        ChatStyle style0 = component1.func_150256_b().func_150232_l();
        ChatStyle style1 = this.style.func_150232_l();
        style1.func_150209_a(style0.func_150210_i());
        style1.func_150241_a(style0.func_150235_h());
        component1.func_150255_a(style1);
        this.component.func_150257_a((IChatComponent)component1);
    }

    static {
        for (EnumChatFormatting formatting : TextComponentParser.TEXT_FORMATTING_NAME_MAP.values) {
            CODE_TO_FORMATTING.put(Character.valueOf(formatting.field_96329_z), formatting);
        }
    }
}

