/*
 * Decompiled with CFR 0.152.
 */
package serverutils.mixin;

import com.gtnewhorizon.gtnhmixins.builders.IBaseTransformer;
import com.gtnewhorizon.gtnhmixins.builders.IMixins;
import com.gtnewhorizon.gtnhmixins.builders.ITargetMod;
import com.gtnewhorizon.gtnhmixins.builders.MixinBuilder;
import org.jetbrains.annotations.NotNull;
import serverutils.ServerUtilitiesConfig;
import serverutils.mixin.TargetedMod;

public enum Mixins implements IMixins
{
    COMMAND_PERMISSIONS(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> ServerUtilitiesConfig.ranks.enabled && ServerUtilitiesConfig.ranks.command_permissions).addCommonMixins(new String[]{"minecraft.MixinCommandBase", "minecraft.MixinCommandHandler", "minecraft.MixinICommand"})),
    REPLACE_TAB_NAMES(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).addClientMixins(new String[]{"forge.MixinGuiIngameForge"})),
    VANILLA_TP_BACK_COMPAT(new MixinBuilder("/back compat for the vanilla /tp").setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> ServerUtilitiesConfig.commands.back).addCommonMixins(new String[]{"minecraft.MixinCommandTeleport"})),
    VANISH_COMMAND(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> ServerUtilitiesConfig.commands.vanish).addServerMixins(new String[]{"minecraft.vanish.MixinServerConfigurationManager", "minecraft.vanish.MixinMinecraftServer", "minecraft.vanish.MixinEntityTrackerEntry", "minecraft.vanish.MixinNetHandlerPlayServer", "minecraft.vanish.MixinCommandListPlayers", "minecraft.vanish.MixinEntityPlayer", "minecraft.vanish.MixinEntityPlayerMP", "minecraft.vanish.MixinWorld", "minecraft.vanish.MixinItemInWorldManager"})),
    HIDE_VANISHED_FROM_DETECTOR(new MixinBuilder("Hide vanished players from the RandomThings online detector").addRequiredMod((ITargetMod)TargetedMod.RANDOMTHINGS).setPhase(IBaseTransformer.Phase.LATE).setApplyIf(() -> ServerUtilitiesConfig.commands.vanish).addServerMixins(new String[]{"randomthings.MixinWorldUtils"})),
    PAUSE_WHEN_EMPTY(new MixinBuilder("Pauses the server when empty after X seconds; Servers Only").setPhase(IBaseTransformer.Phase.EARLY).addServerMixins(new String[]{"minecraft.MixinMinecraftServer_PauseWhenEmpty", "minecraft.MixinDedicatedServer_PauseWhenEmpty"}).setApplyIf(() -> ServerUtilitiesConfig.general.enable_pause_when_empty_property)),
    MAX_TICK_TIME(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).addServerMixins(new String[]{"minecraft.MixinDedicatedServer_MaxTickTime", "minecraft.MixinMinecraftServer_MaxTickTime"}).addExcludedMod((ITargetMod)TargetedMod.ULTRAMINE).setApplyIf(() -> ServerUtilitiesConfig.general.enable_max_tick_time_property)),
    PLAYERS_SLEEPING_PERCENTAGE(new MixinBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> ServerUtilitiesConfig.world.enable_player_sleeping_percentage).addCommonMixins(new String[]{"minecraft.MixinWorldServer_SleepPercentage"})),
    DISABLE_ENDERMEN_GRIEFING(new MixinBuilder("Disable Endermen Griefing in Claimed Chunks").setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> ServerUtilitiesConfig.mixins.endermen).addCommonMixins(new String[]{"minecraft.MixinEndermanGriefing"})),
    BYPASS_PLAYER_LIMIT(new MixinBuilder("Adds permission for bypassing player limit").setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> ServerUtilitiesConfig.mixins.bypassPlayerLimit).addCommonMixins(new String[]{"minecraft.MixinNetHandlerLoginServer"})),
    CUSTOM_MOTD(new MixinBuilder("Custom configurable MOTD with color codes and variables").setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> ServerUtilitiesConfig.motd.enabled).addServerMixins(new String[]{"minecraft.MixinMinecraftServer_CustomMotd"})),
    TOGGLE_CHEATS(new MixinBuilder("Helper method for toggling cheats in the world selection menu").setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> ServerUtilitiesConfig.general.enable_toggle_cheats_button).addClientMixins(new String[]{"minecraft.AccessorSaveFormatComparator"}));

    private final MixinBuilder builder;

    private Mixins(MixinBuilder builder) {
        this.builder = builder;
    }

    @NotNull
    public MixinBuilder getBuilder() {
        return this.builder;
    }
}

