/*
 * Decompiled with CFR 0.152.
 */
package serverutils.mixins.early.minecraft;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.storage.ISaveHandler;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import serverutils.ServerUtilitiesConfig;
import serverutils.data.ServerUtilitiesPlayerData;

@Mixin(value={WorldServer.class})
public abstract class MixinWorldServer_SleepPercentage
extends World {
    @Shadow
    private boolean field_73068_P;
    @Shadow
    @Final
    private MinecraftServer field_73061_a;
    @Unique
    private int percent;
    @Unique
    private List<EntityPlayer> sleepingPlayers;
    @Unique
    private Set<UUID> previousSleepingPlayers;

    public MixinWorldServer_SleepPercentage(ISaveHandler p_i45368_1_, String p_i45368_2_, WorldProvider p_i45368_3_, WorldSettings p_i45368_4_, Profiler p_i45368_5_) {
        super(p_i45368_1_, p_i45368_2_, p_i45368_3_, p_i45368_4_, p_i45368_5_);
        throw new RuntimeException("Server Utilities player sleeping percentage broke in a huge way. This error should never happen");
    }

    @Inject(method={"updateAllPlayersSleepingFlag"}, at={@At(value="HEAD")}, cancellable=true)
    public void serverutilities$handlePlayersSleepingPercentage(CallbackInfo ci) {
        this.percent = Integer.parseInt(this.func_82736_K().func_82767_a("playersSleepingPercentage"));
        if (this.percent > 100) {
            this.field_73068_P = false;
            ci.cancel();
        } else {
            EntityPlayer theSleeper = null;
            if (this.sleepingPlayers == null) {
                this.sleepingPlayers = new ArrayList<EntityPlayer>();
            }
            this.sleepingPlayers.clear();
            int playerCountWithoutAFK = this.serverutilities$getListWithoutAFK(this.field_73010_i).size();
            int cap = (int)Math.ceil((float)(playerCountWithoutAFK * this.percent) * 0.01f);
            for (EntityPlayer player : this.field_73010_i) {
                if (!player.func_70608_bn()) continue;
                this.sleepingPlayers.add(player);
                if (!this.previousSleepingPlayers.contains(player.func_110124_au())) {
                    theSleeper = player;
                }
                if (this.sleepingPlayers.size() < cap) continue;
                this.field_73068_P = true;
                break;
            }
            this.previousSleepingPlayers = this.sleepingPlayers.stream().map(Entity::func_110124_au).collect(Collectors.toSet());
            if (!this.sleepingPlayers.isEmpty() && cap > 0 && theSleeper != null && !this.field_73061_a.func_71264_H()) {
                for (EntityPlayer player : this.field_73010_i) {
                    String percentString = String.format("%d", this.sleepingPlayers.size() * 100 / playerCountWithoutAFK);
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("serverutilities.world.players_sleeping", new Object[]{theSleeper.getDisplayName(), this.sleepingPlayers.size(), playerCountWithoutAFK, percentString}));
                }
            }
            ci.cancel();
        }
    }

    @Redirect(method={"areAllPlayersAsleep"}, at=@At(value="FIELD", target="Lnet/minecraft/world/WorldServer;playerEntities:Ljava/util/List;", opcode=180))
    public List<EntityPlayer> serverutilities$speedup1(WorldServer instance) {
        return this.sleepingPlayers.isEmpty() ? this.field_73010_i : this.sleepingPlayers;
    }

    @Inject(method={"areAllPlayersAsleep"}, at={@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;")}, cancellable=true)
    public void serverutilities$speedup2(CallbackInfoReturnable<Boolean> ctx) {
        if (this.percent < 1) {
            ctx.setReturnValue((Object)true);
        }
    }

    @Inject(method={"wakeAllPlayers"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;wakeUpPlayer(ZZZ)V")})
    public void serverutilities$broadcast(CallbackInfo ctx, @Local EntityPlayer player) {
        if (this.percent > 0 && this.percent < 100 && !this.field_73061_a.func_71264_H()) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("serverutiltiies.world.skip_night", new Object[0]));
        }
    }

    @Unique
    public List<EntityPlayer> serverutilities$getListWithoutAFK(List<EntityPlayer> list) {
        return list.stream().filter(player -> {
            ServerUtilitiesPlayerData data = ServerUtilitiesPlayerData.getNullable(player);
            return data == null || data.afkTime <= ServerUtilitiesConfig.afk.getNotificationTimer();
        }).collect(Collectors.toList());
    }
}

