/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker;

import net.minecraft.item.ItemStack;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.foodtracker.FoodHistory;

public final class ProgressInfo {
    public static final int FOOD_POINTS_PER_MILESTONE = ModConfig.FOOD_MILESTONE_VALUE;
    public static final double INCREMENT_PER_MILESTONE = ModConfig.MILESTONE_INCREMENT_VALUE;
    public static final int HEARTS_PER_MILESTONE = ModConfig.HEARTS_PER_MILESTONE_VALUE;
    public static final int MAX_MILESTONE_VALUE = ModConfig.MAX_MILESTONE_VALUE;
    public boolean hasCap = MAX_MILESTONE_VALUE > 0;
    public final int foodsPointsEaten;

    ProgressInfo(FoodHistory foodList) {
        this.foodsPointsEaten = foodList.getFullHistory().stream().filter(eaten -> ProgressInfo.shouldCount(eaten.itemStack)).mapToInt(eaten -> eaten.foodValues.hunger).sum();
    }

    public static boolean shouldCount(ItemStack food) {
        return true;
    }

    public int foodPointsUntilNextMilestone() {
        return Math.max(0, this.nextMilestoneFoodPoints() - this.foodsPointsEaten);
    }

    public int nextMilestoneFoodPoints() {
        int nextMilestone = this.milestonesAchieved() + 1;
        if (this.hasCap && nextMilestone > MAX_MILESTONE_VALUE) {
            return 0;
        }
        if (INCREMENT_PER_MILESTONE > 0.0) {
            double quadraticIncrement = INCREMENT_PER_MILESTONE * 0.5;
            double quadraticBase = (double)FOOD_POINTS_PER_MILESTONE - quadraticIncrement;
            return (int)(quadraticBase * (double)nextMilestone + quadraticIncrement * (double)nextMilestone * (double)nextMilestone);
        }
        return nextMilestone * FOOD_POINTS_PER_MILESTONE;
    }

    public int milestonesAchieved() {
        int milestonesTotal;
        if (INCREMENT_PER_MILESTONE > 0.0) {
            double quadraticIncrement = INCREMENT_PER_MILESTONE * 0.5;
            double quadraticBase = (double)FOOD_POINTS_PER_MILESTONE - quadraticIncrement;
            double discriminant = Math.sqrt(quadraticBase * quadraticBase + 4.0 * quadraticIncrement * (double)this.foodsPointsEaten);
            double milestone1 = (-quadraticBase + discriminant) / (2.0 * quadraticIncrement);
            double milestone2 = (-quadraticBase - discriminant) / (2.0 * quadraticIncrement);
            milestonesTotal = (int)Math.floor(Math.max(milestone1, milestone2));
        } else {
            milestonesTotal = (int)Math.floor((double)this.foodsPointsEaten / (double)FOOD_POINTS_PER_MILESTONE);
        }
        if (this.hasCap && milestonesTotal >= MAX_MILESTONE_VALUE) {
            return MAX_MILESTONE_VALUE;
        }
        return milestonesTotal;
    }
}

