/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.components;

import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import stevesaddons.api.IHiddenInventory;
import vswe.stevesfactory.components.ItemBufferElement;
import vswe.stevesfactory.components.ItemSetting;
import vswe.stevesfactory.components.Setting;
import vswe.stevesfactory.components.SlotInventoryHolder;

public class AdvancedOutputItemCounter {
    private Setting setting;
    private boolean useWhiteList;
    private int currentInventoryStackSize;
    private int currentBufferStackSize;

    public AdvancedOutputItemCounter(List<ItemBufferElement> itemBuffer, List<SlotInventoryHolder> inventories, IInventory inventory, Setting setting, boolean useWhiteList) {
        block7: {
            this.setting = setting;
            this.useWhiteList = useWhiteList;
            if (setting == null || ((ItemSetting)setting).getItem() == null || !setting.isLimitedByAmount()) break block7;
            if (useWhiteList) {
                if (inventories.get(0).isShared()) {
                    for (SlotInventoryHolder itemBufferElement : inventories) {
                        if (itemBufferElement.getTile() instanceof IHiddenInventory) {
                            this.addInventory((IHiddenInventory)itemBufferElement.getTile());
                            continue;
                        }
                        this.addInventory(itemBufferElement.getInventory());
                    }
                } else {
                    this.addInventory(inventory);
                }
            } else {
                for (ItemBufferElement itemBufferElement1 : itemBuffer) {
                    this.currentBufferStackSize += itemBufferElement1.getBufferSize(setting);
                }
            }
        }
    }

    private void addInventory(IHiddenInventory inventory) {
        this.currentInventoryStackSize += inventory.getExistingStackSize((ItemSetting)this.setting);
    }

    private void addInventory(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            if (!((ItemSetting)this.setting).isEqualForCommandExecutor(item)) continue;
            this.currentInventoryStackSize += item.field_77994_a;
        }
    }

    public boolean areSettingsSame(Setting setting) {
        return this.setting == null && setting == null || this.setting != null && setting != null && this.setting.getId() == setting.getId();
    }

    public int retrieveItemCount(int desiredItemCount) {
        if (this.setting != null && this.setting.isLimitedByAmount()) {
            int itemsAllowedToBeMoved = this.useWhiteList ? ((ItemSetting)this.setting).getItem().field_77994_a - this.currentInventoryStackSize : this.currentBufferStackSize - ((ItemSetting)this.setting).getItem().field_77994_a;
            return Math.min(itemsAllowedToBeMoved, desiredItemCount);
        }
        return desiredItemCount;
    }

    public void modifyStackSize(int itemsToMove) {
        if (this.useWhiteList) {
            this.currentInventoryStackSize += itemsToMove;
        } else {
            this.currentBufferStackSize -= itemsToMove;
        }
    }
}

