/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.interfaces;

import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import stevesaddons.interfaces.GuiLabeler;
import stevesaddons.interfaces.IVerticalScrollContainer;

public class GuiVerticalScrollBar
extends Gui {
    Minecraft mc;
    IVerticalScrollContainer container;
    int mouseX;
    int mouseY;
    int width = 12;
    int height = 15;
    int xpos;
    int ypos;
    int startingYPos;
    int maxDisplacement;
    float scaleFactor;
    float scrollValue = 0.0f;
    boolean isDragging = false;
    int activeU = 232;
    int activeV = 0;
    int unactiveU = 244;
    int unactiveV = 0;

    public GuiVerticalScrollBar(IVerticalScrollContainer container, int x, int y, int maxDisplacement) {
        this.container = container;
        this.xpos = x;
        this.ypos = y;
        this.startingYPos = y;
        this.maxDisplacement = maxDisplacement - this.height;
        this.scaleFactor = 1.0f / (float)this.maxDisplacement;
        this.mc = FMLClientHandler.instance().getClient();
    }

    public void handleMouseInput() {
        int screenWidth = this.container.getScreenWidth();
        int screenHeight = this.container.getScreenHeight();
        int parentWidth = this.container.getGuiWidth();
        int parentHeight = this.container.getGuiHeight();
        int i = Mouse.getEventX() * screenWidth / this.mc.field_71443_c;
        int j = screenHeight - Mouse.getEventY() * screenHeight / this.mc.field_71440_d - 1;
        this.mouseX = i - (screenWidth - parentWidth) / 2;
        this.mouseY = j - (screenHeight - parentHeight) / 2;
        int eventButton = Mouse.getEventButton();
        if (Mouse.getEventButtonState()) {
            this.onMouseClick();
        } else if (eventButton == -1) {
            this.onMouseMoved(Mouse.getDX(), Mouse.getDY());
        } else if (eventButton == 1 || eventButton == 0) {
            this.onMouseRelease();
        }
        int wheelValue = Mouse.getEventDWheel();
        if (wheelValue != 0) {
            if (wheelValue > 0) {
                this.onMouseScroll(wheelValue, true);
            } else if (wheelValue < 0) {
                this.onMouseScroll(wheelValue, false);
            }
        }
    }

    public boolean pointIntersects(int x, int y) {
        return x >= this.xpos && x <= this.xpos + this.width && y >= this.ypos && y <= this.ypos + this.height;
    }

    public boolean pointInScrollBar(int x, int y) {
        return x >= this.xpos && x <= this.xpos + this.width && y >= this.startingYPos && y <= this.startingYPos + this.maxDisplacement + this.height;
    }

    public void setYPos(int y) {
        this.ypos = y;
        if (this.ypos < this.startingYPos) {
            this.ypos = this.startingYPos;
        }
        if (this.ypos > this.startingYPos + this.maxDisplacement) {
            this.ypos = this.startingYPos + this.maxDisplacement;
        }
        this.scrollValue = (float)(this.ypos - this.startingYPos) * this.scaleFactor;
    }

    private void onMouseClick() {
        if (this.container.isScrollBarActive()) {
            if (this.pointIntersects(this.mouseX, this.mouseY)) {
                this.isDragging = true;
            } else if (this.pointInScrollBar(this.mouseX, this.mouseY)) {
                int scrollAmount = this.height;
                if (this.mouseY < this.ypos) {
                    this.setYPos(this.ypos - scrollAmount);
                } else if (this.mouseY > this.ypos + this.height) {
                    this.setYPos(this.ypos + scrollAmount);
                }
            }
        }
    }

    private void onMouseRelease() {
        this.isDragging = false;
    }

    private void onMouseMoved(int dx, int dy) {
        if (this.container.isScrollBarActive() && this.isDragging) {
            this.setYPos(this.mouseY);
        }
    }

    private void onMouseScroll(int value, boolean up) {
        if (!this.container.isScrollBarActive()) {
            return;
        }
        if (up) {
            this.setYPos(this.ypos - this.container.getScrollAmount());
        } else {
            this.setYPos(this.ypos + this.container.getScrollAmount());
        }
    }

    public float getScrollValue() {
        return this.scrollValue;
    }

    public void draw() {
        GuiVerticalScrollBar.func_73734_a((int)(this.xpos - 1), (int)(this.startingYPos - 1), (int)(this.xpos + this.width + 1), (int)(this.startingYPos + this.maxDisplacement + this.height + 1), (int)-8882056);
        GuiVerticalScrollBar.func_73734_a((int)this.xpos, (int)this.startingYPos, (int)(this.xpos + this.width), (int)(this.startingYPos + this.maxDisplacement + this.height), (int)-6513508);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.field_71446_o.func_110577_a(GuiLabeler.TEXTURE);
        if (this.container.isScrollBarActive()) {
            this.func_73729_b(this.xpos, this.ypos, this.activeU, this.activeV, this.width, this.height);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
            this.func_73729_b(this.xpos, this.ypos, this.unactiveU, this.unactiveV, this.width, this.height);
        }
    }
}

