/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Engines;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.api.electricity.IElectricMinecart;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.Localization;
import vswe.stevescarts.Helpers.ResourceHelper;
import vswe.stevescarts.Interfaces.GuiMinecart;
import vswe.stevescarts.Modules.Engines.ModuleEngine;

public class ModuleElectricBase
extends ModuleEngine
implements IElectricMinecart {
    private final IElectricMinecart.ChargeHandler chargeHandler = new IElectricMinecart.ChargeHandler((EntityMinecart)this.getCart(), IElectricMinecart.ChargeHandler.Type.USER, (double)this.getMaxCharge());
    private int clientFuelLevel = 0;
    private final int[] chargeRect = new int[]{10, 15, 52, 15};

    protected int getMaxCharge() {
        return 7500;
    }

    public ModuleElectricBase(MinecartModular cart) {
        super(cart);
    }

    @Override
    public int getFuelLevel() {
        return (int)this.getChargeHandler().getCharge();
    }

    @Override
    protected void loadFuel() {
    }

    @Override
    public void consumeFuel(int comsumption) {
        this.getChargeHandler().removeCharge((double)comsumption);
    }

    @Override
    public void setFuelLevel(int val) {
        this.getChargeHandler().setCharge((double)val);
    }

    @Override
    public int getTotalFuel() {
        return (int)this.getChargeHandler().getCapacity();
    }

    @Override
    public float[] getGuiBarColor() {
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, Localization.MODULES.ENGINES.ELECTRIC.translate(new String[0]), 8, 6, 0x404040);
        String strfuel = Localization.MODULES.ENGINES.NO_CHARGE.translate(new String[0]);
        if (this.clientFuelLevel > 0) {
            strfuel = Localization.MODULES.ENGINES.CHARGE.translate(String.valueOf(this.clientFuelLevel));
        }
        this.drawString(gui, strfuel, 8, 34, 0x404040);
    }

    @Override
    protected void initPriorityButton() {
        this.priorityButton = new int[]{88, 7, 16, 16};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiMinecart gui, int x, int y) {
        super.drawBackground(gui, x, y);
        ResourceHelper.bindResource("/gui/energy.png");
        this.drawBox(gui, 0, 0, 1.0f);
        this.drawBox(gui, 0, 15, (float)((double)this.clientFuelLevel / this.getChargeHandler().getCapacity()));
    }

    private void drawBox(GuiMinecart gui, int u, int v, float mult) {
        int w = (int)((float)this.chargeRect[2] * mult);
        if (w > 0) {
            this.drawImage(gui, this.chargeRect[0], this.chargeRect[1], u, v, w, this.chargeRect[3]);
        }
    }

    @Override
    public int guiHeight() {
        return 45;
    }

    @Override
    public int guiWidth() {
        return 110;
    }

    @Override
    public int numberOfGuiData() {
        return 1;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        this.updateGuiData(info, 0, (short)this.getFuelLevel());
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            this.clientFuelLevel = data;
            if (this.clientFuelLevel < 0) {
                this.clientFuelLevel += 65536;
            }
        }
    }

    @Override
    public void update() {
        super.update();
        if (!this.getCart().field_70170_p.field_72995_K) {
            this.getChargeHandler().tick();
        }
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        super.Save(tagCompound, id);
        this.chargeHandler.writeToNBT(tagCompound);
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        super.Load(tagCompound, id);
        this.chargeHandler.readFromNBT(tagCompound);
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    public IElectricMinecart.ChargeHandler getChargeHandler() {
        return this.chargeHandler;
    }
}

