/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vswe.stevesfactory.blocks.ModBlocks;
import vswe.stevesfactory.blocks.TileEntityCamouflage;
import vswe.stevesfactory.blocks.TileEntityCluster;

public abstract class BlockCamouflageBase
extends BlockContainer {
    protected BlockCamouflageBase(Material material) {
        super(material);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        if (!this.setBlockCollisionBoundsBasedOnState((IBlockAccess)world, x, y, z)) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        return super.func_149633_g(world, x, y, z);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        if (!this.setBlockCollisionBoundsBasedOnState((IBlockAccess)world, x, y, z)) {
            return null;
        }
        return super.func_149668_a(world, x, y, z);
    }

    private boolean setBlockCollisionBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        this.func_149719_a(world, x, y, z);
        TileEntityCamouflage camouflage = (TileEntityCamouflage)TileEntityCluster.getTileEntity(TileEntityCamouflage.class, world, x, y, z);
        if (camouflage != null && camouflage.getCamouflageType().useSpecialShape()) {
            if (!camouflage.isUseCollision()) {
                return false;
            }
            if (camouflage.isFullCollision()) {
                this.func_149683_g();
            }
        }
        return true;
    }

    public boolean func_149655_b(IBlockAccess world, int x, int y, int z) {
        TileEntityCamouflage camouflage = (TileEntityCamouflage)TileEntityCluster.getTileEntity(TileEntityCamouflage.class, world, x, y, z);
        return camouflage == null || camouflage.isNormalBlock();
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        if (!this.setBlockCollisionBoundsBasedOnState((IBlockAccess)world, x, y, z)) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        return super.func_149731_a(world, x, y, z, start, end);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        TileEntityCamouflage camouflage = (TileEntityCamouflage)TileEntityCluster.getTileEntity(TileEntityCamouflage.class, (IBlockAccess)worldObj, target.field_72311_b, target.field_72312_c, target.field_72309_d);
        return camouflage != null && camouflage.addBlockEffect((Block)this, target.field_72310_e, effectRenderer);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        TileEntityCamouflage camouflage = (TileEntityCamouflage)TileEntityCluster.getTileEntity(TileEntityCamouflage.class, world, x, y, z);
        if (camouflage != null && camouflage.getCamouflageType().useSpecialShape()) {
            camouflage.setBlockBounds(this);
        } else {
            this.func_149683_g();
        }
    }

    public float func_149712_f(World world, int x, int y, int z) {
        TileEntityCamouflage camouflage = (TileEntityCamouflage)TileEntityCluster.getTileEntity(TileEntityCamouflage.class, (IBlockAccess)world, x, y, z);
        if (camouflage != null && camouflage.getCamouflageType().useSpecialShape() && !camouflage.isUseCollision()) {
            return 600000.0f;
        }
        return super.func_149712_f(world, x, y, z);
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public int func_149645_b() {
        return ModBlocks.CAMOUFLAGE_RENDER_ID;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public final IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        IIcon icon;
        TileEntityCamouflage te = (TileEntityCamouflage)TileEntityCluster.getTileEntity(TileEntityCamouflage.class, world, x, y, z);
        if (te != null && (icon = te.getIconWithDefault(world, x, y, z, this, side, false)) != null) {
            return icon;
        }
        return this.getDefaultIcon(side, world.func_72805_g(x, y, z), 0);
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract IIcon getDefaultIcon(int var1, int var2, int var3);
}

