/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import vswe.stevesfactory.CollisionHelper;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.components.ComponentMenuItem;
import vswe.stevesfactory.components.ComponentMenuStuff;
import vswe.stevesfactory.components.CraftingDummy;
import vswe.stevesfactory.components.CraftingSetting;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.Setting;
import vswe.stevesfactory.interfaces.GuiManager;

public class ComponentMenuCrafting
extends ComponentMenuItem {
    private CraftingSetting resultItem = new CraftingSetting(9){

        @Override
        public boolean canChangeMetaData() {
            return false;
        }

        @Override
        public void delete() {
            for (Setting setting : ComponentMenuCrafting.this.settings) {
                setting.clear();
                ComponentMenuCrafting.this.writeServerData(ComponentMenuStuff.DataTypeHeader.CLEAR, setting);
            }
        }
    };
    private CraftingDummy dummy;
    private boolean editingResult = false;

    public ComponentMenuCrafting(FlowComponent parent) {
        super(parent, CraftingSetting.class);
        this.settings.add(this.resultItem);
        this.dummy = new CraftingDummy(this);
        this.scrollControllerSelected.setItemsPerRow(3);
        this.scrollControllerSelected.setVisibleRows(3);
        this.scrollControllerSelected.setItemUpperLimit(2);
        this.scrollControllerSelected.setDisabledScroll(true);
    }

    @Override
    public String getName() {
        return Localization.CRAFTING_MENU.toString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        super.draw(gui, mX, mY);
        if (!this.isEditing() && !this.isSearching() && this.resultItem.getItem() != null) {
            this.drawResultObject(gui, this.resultItem.getItem(), this.getResultX(), this.getResultY());
            gui.drawItemAmount(this.resultItem.getItem(), this.getResultX(), this.getResultY());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
        super.drawMouseOver(gui, mX, mY);
        if (!this.isEditing() && !this.isSearching() && this.resultItem.getItem() != null && CollisionHelper.inBounds(this.getResultX(), this.getResultY(), 16, 16, mX, mY)) {
            gui.drawMouseOver(this.getResultObjectMouseOver(this.resultItem.getItem()), mX, mY);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClick(int mX, int mY, int button) {
        super.onClick(mX, mY, button);
        if (!this.isEditing()) {
            this.editingResult = false;
        }
        if (!this.isEditing() && !this.isSearching() && this.resultItem.getItem() != null && button == 1 && CollisionHelper.inBounds(this.getResultX(), this.getResultY(), 16, 16, mX, mY)) {
            this.editingResult = true;
            this.scrollControllerSelected.onClick(this.resultItem, mX, mY, 1);
        }
    }

    public Boolean isEditingResult() {
        return this.editingResult;
    }

    private int getResultX() {
        return 65;
    }

    private int getResultY() {
        return this.scrollControllerSelected.getScrollingStartY() + 20;
    }

    @Override
    protected int getSettingCount() {
        return 9;
    }

    @Override
    protected void initRadioButtons() {
    }

    @Override
    protected void onSettingContentChange() {
        this.resultItem.setItem(this.dummy.getResult());
    }

    public CraftingDummy getDummy() {
        return this.dummy;
    }

    public CraftingSetting getResultItem() {
        return this.resultItem;
    }
}

