/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawersCustom;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrimCustom;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityFramingTable
extends TileEntity
implements IInventory {
    private ItemStack[] tableItemStacks = new ItemStack[5];
    private String customName;
    private static final AxisAlignedBB ZERO_EXTENT_AABB = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);

    public int func_70302_i_() {
        return this.tableItemStacks.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.tableItemStacks[slot];
    }

    public ItemStack func_70298_a(int slot, int count) {
        if (this.tableItemStacks[slot] != null) {
            if (this.tableItemStacks[slot].field_77994_a <= count) {
                ItemStack stack = this.tableItemStacks[slot];
                this.tableItemStacks[slot] = null;
                this.func_70296_d();
                return stack;
            }
            ItemStack stack = this.tableItemStacks[slot].func_77979_a(count);
            if (this.tableItemStacks[slot].field_77994_a == 0) {
                this.tableItemStacks[slot] = null;
            }
            this.func_70296_d();
            return stack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.tableItemStacks[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "storageDrawers.container.framingTable";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return TileEntityFramingTable.isItemValidDrawer(stack);
        }
        if (slot == 4) {
            return false;
        }
        if (slot >= 1 && slot < 4) {
            return TileEntityFramingTable.isItemValidMaterial(stack);
        }
        return false;
    }

    public static boolean isItemValidDrawer(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        return block instanceof BlockDrawersCustom || block instanceof BlockTrimCustom;
    }

    public static boolean isItemValidMaterial(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block == null) {
            return false;
        }
        return block.func_149662_c();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList itemList = tag.func_150295_c("Items", 10);
        this.tableItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound item = itemList.func_150305_b(i);
            byte slot = item.func_74771_c("Slot");
            if (slot < 0 || slot >= this.tableItemStacks.length) continue;
            this.tableItemStacks[slot] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
        if (tag.func_150297_b("CustomName", 8)) {
            this.customName = tag.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.tableItemStacks.length; ++i) {
            if (this.tableItemStacks[i] == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            this.tableItemStacks[i].func_77955_b(item);
            itemList.func_74742_a((NBTBase)item);
        }
        tag.func_74782_a("Items", (NBTBase)itemList);
        if (this.func_145818_k_()) {
            tag.func_74778_a("CustomName", this.customName);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        int meta = this.func_145832_p();
        if ((meta & 8) != 0) {
            return ZERO_EXTENT_AABB;
        }
        int side = meta & 7;
        int xOff = 0;
        int zOff = 0;
        if (side == 2) {
            xOff = 1;
        }
        if (side == 3) {
            xOff = -1;
        }
        if (side == 4) {
            zOff = -1;
        }
        if (side == 5) {
            zOff = 1;
        }
        int xMin = Math.min(this.field_145851_c, this.field_145851_c + xOff);
        int xMax = Math.max(this.field_145851_c, this.field_145851_c + xOff) + 1;
        int zMin = Math.min(this.field_145849_e, this.field_145849_e + zOff);
        int zMax = Math.max(this.field_145849_e, this.field_145849_e + zOff) + 1;
        return AxisAlignedBB.func_72330_a((double)xMin, (double)(this.field_145848_d + 1), (double)xMax, (double)zMin, (double)(this.field_145848_d + 2), (double)zMax);
    }
}

