/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.block.BlockTrimCustom;
import com.jaquadro.minecraft.storagedrawers.client.renderer.common.CommonTrimRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class TrimItemRender
implements IItemRenderer {
    private CommonTrimRenderer commonRender = new CommonTrimRenderer();

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        RenderBlocks renderer = this.getRenderer(data);
        if (renderer == null) {
            return;
        }
        Block block = Block.func_149634_a((Item)item.func_77973_b());
        if (!(block instanceof BlockTrimCustom)) {
            return;
        }
        this.renderTrim((BlockTrimCustom)block, item, renderer, type);
    }

    private void renderTrim(BlockTrimCustom block, ItemStack item, RenderBlocks renderer, IItemRenderer.ItemRenderType renderType) {
        if (renderType == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (renderType == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (renderType == IItemRenderer.ItemRenderType.INVENTORY || renderType == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        }
        ItemStack materialSide = null;
        ItemStack materialTrim = null;
        if (item.func_77942_o()) {
            NBTTagCompound tag = item.func_77978_p();
            if (tag.func_74764_b("MatS")) {
                materialSide = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("MatS"));
            }
            if (tag.func_74764_b("MatT")) {
                materialTrim = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("MatT"));
            }
        }
        if (materialSide == null) {
            materialSide = new ItemStack((Block)block);
        }
        if (materialTrim == null) {
            materialTrim = materialSide;
        }
        IIcon trimIcon = Block.func_149634_a((Item)materialTrim.func_77973_b()).func_149691_a(4, materialTrim.func_77960_j());
        IIcon panelIcon = Block.func_149634_a((Item)materialSide.func_77973_b()).func_149691_a(4, materialSide.func_77960_j());
        if (trimIcon == null) {
            trimIcon = block.getDefaultTrimIcon();
        }
        if (panelIcon == null) {
            panelIcon = block.getDefaultFaceIcon();
        }
        this.commonRender.render(null, 0, 0, 0, block, panelIcon, trimIcon);
        if (renderType == IItemRenderer.ItemRenderType.INVENTORY || renderType == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }

    private RenderBlocks getRenderer(Object[] data) {
        for (Object obj : data) {
            if (!(obj instanceof RenderBlocks)) continue;
            return (RenderBlocks)obj;
        }
        return null;
    }
}

