/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.integration.IntegrationModule;
import com.jaquadro.minecraft.storagedrawers.integration.thermalfoundation.CoFHSecurityProvider;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Method;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ThermalFoundation
extends IntegrationModule {
    private Class classRegistrySocial;
    private Method methodPlayerHasAccess;

    @Override
    public String getModID() {
        return "ThermalFoundation";
    }

    @Override
    public void init() throws Throwable {
        try {
            this.classRegistrySocial = Class.forName("cofh.core.RegistrySocial");
        }
        catch (ClassNotFoundException e) {
            this.classRegistrySocial = Class.forName("cofh.core.util.SocialRegistry");
        }
        this.methodPlayerHasAccess = this.classRegistrySocial.getDeclaredMethod("playerHasAccess", String.class, GameProfile.class);
    }

    @Override
    public void postInit() {
        StorageDrawers.securityRegistry.registerProvider(new CoFHSecurityProvider(this));
        if (StorageDrawers.config.cache.enablePersonalUpgrades) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.personalKey, 1, 1), new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), "nuggetSignalum", Character.valueOf('y'), ModItems.personalKey}));
        }
    }

    public boolean playerHasAccess(String playerName, GameProfile owner) {
        try {
            return (Boolean)this.methodPlayerHasAccess.invoke(null, playerName, owner);
        }
        catch (Throwable t) {
            return false;
        }
    }
}

