/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersStandard;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemDrawers
extends ItemBlock {
    public ItemDrawers(Block block) {
        super(block);
        this.func_77656_e(0);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (!super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata)) {
            return false;
        }
        TileEntityDrawers tile = (TileEntityDrawers)world.func_147438_o(x, y, z);
        if (tile != null) {
            BlockDrawers block = (BlockDrawers)this.field_150939_a;
            if (tile instanceof TileEntityDrawersStandard) {
                ((TileEntityDrawersStandard)tile).setDrawerCount(block.drawerCount);
            }
            tile.setDrawerCapacity(this.getCapacityForBlock((Block)block));
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("tile")) {
                tile.readFromPortableNBT(stack.func_77978_p().func_74775_l("tile"));
            }
            if (side > 1) {
                tile.setDirection(side);
            }
            tile.setIsSealed(false);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        if (itemStack.func_77942_o()) {
            NBTTagCompound tag = itemStack.func_77978_p();
            if (tag.func_74764_b("tile")) {
                NBTTagCompound tileTag = tag.func_74775_l("tile");
                ItemStack[] upgrades = new ItemStack[5];
                int drawerCapacity = this.getUpgradesAndDrawerCapacity(tileTag, upgrades);
                this.addDescriptionInformation(drawerCapacity, list);
                if (Keyboard.isKeyDown((int)42)) {
                    this.addStatsInformation(tileTag, player, list);
                    this.addDrawersInformation(tileTag, list);
                    this.addUpgradesInformation(upgrades, list);
                    this.addSealedContentsInformation(tileTag, list);
                } else {
                    list.add(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed"));
                    list.add(EnumChatFormatting.DARK_GRAY + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.descriptionShift"));
                }
            } else {
                this.addAlternativeTagInformation(itemStack, player, list, par4);
            }
        } else {
            Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
            this.addNoneTagDescriptionInformation(this.getCapacityForBlock(block), list);
        }
    }

    protected int getCapacityForBlock(Block block) {
        ConfigManager config = StorageDrawers.config;
        int count = 0;
        if (!(block instanceof BlockDrawers)) {
            return 0;
        }
        BlockDrawers drawer = (BlockDrawers)block;
        if (drawer.drawerCount == 1) {
            count = config.getBlockBaseStorage("fulldrawers1");
        } else if (drawer.drawerCount == 2 && !drawer.halfDepth) {
            count = config.getBlockBaseStorage("fulldrawers2");
        } else if (drawer.drawerCount == 4 && !drawer.halfDepth) {
            count = config.getBlockBaseStorage("fulldrawers4");
        } else if (drawer.drawerCount == 2 && drawer.halfDepth) {
            count = config.getBlockBaseStorage("halfdrawers2");
        } else if (drawer.drawerCount == 4 && drawer.halfDepth) {
            count = config.getBlockBaseStorage("halfdrawers4");
        } else if (drawer.drawerCount == 3) {
            count = config.getBlockBaseStorage("compDrawers");
        }
        return count;
    }

    protected void addDescriptionInformation(int drawerCapacity, List list) {
        list.add(StatCollector.func_74837_a((String)"storageDrawers.drawers.description", (Object[])new Object[]{drawerCapacity}));
    }

    protected void addNoneTagDescriptionInformation(int drawerCapacity, List list) {
        this.addDescriptionInformation(drawerCapacity, list);
    }

    protected void addAlternativeTagInformation(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
    }

    protected void addStatsInformation(NBTTagCompound tag, EntityPlayer player, List list) {
        ConfigManager config = StorageDrawers.config;
        EnumSet<LockAttribute> lockAttributes = null;
        UUID owner = null;
        boolean shrouded = false;
        boolean quantified = false;
        if (config.cache.enableLockUpgrades && tag.func_74764_b("Lock")) {
            lockAttributes = LockAttribute.getEnumSet(tag.func_74771_c("Lock"));
        }
        if (config.cache.enablePersonalUpgrades && tag.func_74764_b("Own")) {
            owner = UUID.fromString(tag.func_74779_i("Own"));
        }
        if (config.cache.enableShroudUpgrades && tag.func_74764_b("Shr")) {
            shrouded = tag.func_74767_n("Shr");
        }
        if (config.cache.enableQuantifyUpgrades && tag.func_74764_b("Qua")) {
            quantified = tag.func_74767_n("Qua");
        }
        String lockInfo = lockAttributes != null && lockAttributes.contains((Object)LockAttribute.LOCK_POPULATED) ? EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.locked") : EnumChatFormatting.DARK_GRAY + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.unlocked");
        String accessInfo = owner != null ? (player.func_110124_au().equals(owner) ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.access_owner") : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.access_owner")) : EnumChatFormatting.DARK_GRAY + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.access_public");
        list.add(lockInfo + EnumChatFormatting.DARK_GRAY + ", " + accessInfo);
        if (shrouded) {
            list.add(EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.hideItemLabel"));
        } else {
            list.add(EnumChatFormatting.DARK_GRAY + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.showItemLabel"));
        }
        if (quantified) {
            list.add(EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.showItemQuantity"));
        } else {
            list.add(EnumChatFormatting.DARK_GRAY + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.hideItemQuantity"));
        }
    }

    protected void addDrawersInformation(NBTTagCompound tag, List list) {
        NBTTagList slots = tag.func_150295_c("Slots", 10);
        list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.drawerList"));
        for (int i = 0; i < slots.func_74745_c(); ++i) {
            NBTTagCompound slot = slots.func_150305_b(i);
            ItemStack stack = this.getItemStackFromDrawer(slot);
            String slotCounter = EnumChatFormatting.YELLOW + " #" + (i + 1) + ": ";
            if (stack != null) {
                list.add(slotCounter + this.getGoodDisplayName(stack) + " " + this.getItemCountDisplay(stack.func_77976_d(), slot.func_74762_e("Count")));
                continue;
            }
            list.add(slotCounter + EnumChatFormatting.DARK_GRAY + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.drawerEmpty"));
        }
    }

    protected void addUpgradesInformation(ItemStack[] upgrades, List list) {
        list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.upgradeList"));
        boolean hasUpgrades = false;
        for (int i = 0; i < upgrades.length; ++i) {
            ItemStack upgrade = upgrades[i];
            if (upgrade == null) continue;
            list.add(EnumChatFormatting.YELLOW + "  - " + this.getGoodDisplayName(upgrade));
            hasUpgrades = true;
        }
        if (!hasUpgrades) {
            list.add("  " + EnumChatFormatting.DARK_GRAY + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.upgradeNone"));
        }
    }

    protected void addSealedContentsInformation(NBTTagCompound tag, List list) {
    }

    protected ItemStack getItemStackFromDrawer(NBTTagCompound slot) {
        Item item;
        ItemStack stack = null;
        if (slot.func_74764_b("Item") && slot.func_74764_b("Count") && (item = Item.func_150899_d((int)slot.func_74765_d("Item"))) != null) {
            stack = new ItemStack(item, 1, (int)slot.func_74765_d("Meta"));
            if (slot.func_74764_b("Tags")) {
                stack.func_77982_d(slot.func_74775_l("Tags"));
            }
        }
        return stack;
    }

    protected int getUpgradesAndDrawerCapacity(NBTTagCompound tag, ItemStack[] upgrades) {
        ConfigManager config = StorageDrawers.config;
        int multiplier = 0;
        boolean isDowngrade = false;
        if (!tag.func_74764_b("Upgrades")) {
            int i = 0;
            if (tag.func_74764_b("Lev") && tag.func_74771_c("Lev") > 1) {
                upgrades[i] = new ItemStack((Item)ModItems.upgrade, 1, (int)tag.func_74771_c("Lev"));
                multiplier += config.getStorageUpgradeMultiplier(upgrades[i++].func_77960_j());
            }
            if (tag.func_74764_b("Stat")) {
                upgrades[i++] = new ItemStack((Item)ModItems.upgradeStatus, 1, (int)tag.func_74771_c("Stat"));
            }
            if (tag.func_74764_b("Void")) {
                upgrades[i++] = new ItemStack((Item)ModItems.upgradeVoid);
            }
            if (tag.func_74764_b("Down")) {
                upgrades[i] = new ItemStack((Item)ModItems.upgradeDowngrade);
                isDowngrade = true;
            }
        } else {
            NBTTagList upgradeList = tag.func_150295_c("Upgrades", 10);
            for (int i = 0; i < upgradeList.func_74745_c(); ++i) {
                NBTTagCompound upgradeTag = upgradeList.func_150305_b(i);
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)upgradeTag);
                if (stack != null) {
                    if (stack.func_77973_b() == ModItems.upgrade) {
                        multiplier += StorageDrawers.config.getStorageUpgradeMultiplier(stack.func_77960_j());
                    }
                    if (stack.func_77973_b() == ModItems.upgradeDowngrade) {
                        isDowngrade = true;
                    }
                }
                upgrades[i] = stack;
            }
        }
        if (multiplier == 0) {
            multiplier = 1;
        }
        return isDowngrade ? multiplier : tag.func_74765_d("Cap") * multiplier;
    }

    protected String getGoodDisplayName(ItemStack stack) {
        if (stack.func_82837_s()) {
            return EnumChatFormatting.ITALIC.toString() + stack.func_77953_t().field_77937_e + stack.func_82833_r();
        }
        return stack.func_77953_t().field_77937_e.toString() + stack.func_82833_r();
    }

    protected String getItemCountDisplay(int maxStackSize, int itemCount) {
        int numStack = itemCount / maxStackSize;
        int remainder = itemCount - numStack * maxStackSize;
        String itemCountDisplay = numStack > 0 ? (remainder > 0 ? "[" + numStack + "x" + maxStackSize + " + " + remainder + "]" : "[" + numStack + "x" + maxStackSize + "]") : "[" + remainder + "]";
        return EnumChatFormatting.BLUE + itemCountDisplay;
    }
}

