/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.network;

import com.jaquadro.minecraft.storagedrawers.block.IExtendedBlockClickHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class BlockClickMessage
implements IMessage {
    private int x;
    private int y;
    private int z;
    private int side;
    private float hitX;
    private float hitY;
    private float hitZ;
    private boolean invertShift;

    public BlockClickMessage() {
    }

    public BlockClickMessage(int x, int y, int z, int side, float hitX, float hitY, float hitZ, boolean invertShift) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.side = side;
        this.hitX = hitX;
        this.hitY = hitY;
        this.hitZ = hitZ;
        this.invertShift = invertShift;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readShort();
        this.z = buf.readInt();
        this.side = buf.readByte();
        this.hitX = buf.readFloat();
        this.hitY = buf.readFloat();
        this.hitZ = buf.readFloat();
        this.invertShift = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeShort(this.y);
        buf.writeInt(this.z);
        buf.writeByte(this.side);
        buf.writeFloat(this.hitX);
        buf.writeFloat(this.hitY);
        buf.writeFloat(this.hitZ);
        buf.writeBoolean(this.invertShift);
    }

    public static class Handler
    implements IMessageHandler<BlockClickMessage, IMessage> {
        public IMessage onMessage(BlockClickMessage message, MessageContext ctx) {
            World world;
            Block block;
            if (ctx.side == Side.SERVER && (block = (world = ctx.getServerHandler().field_147369_b.func_130014_f_()).func_147439_a(message.x, message.y, message.z)) instanceof IExtendedBlockClickHandler) {
                ((IExtendedBlockClickHandler)block).onBlockClicked(world, message.x, message.y, message.z, (EntityPlayer)ctx.getServerHandler().field_147369_b, message.side, message.hitX, message.hitY, message.hitZ, message.invertShift);
            }
            return null;
        }
    }
}

