/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.tools;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.HarvestTool;
import tconstruct.library.util.AoEExclusionList;

public abstract class AOEHarvestTool
extends HarvestTool {
    public int breakRadius;
    public int breakDepth;

    public AOEHarvestTool(int baseDamage, int breakRadius, int breakDepth) {
        super(baseDamage);
        this.breakRadius = breakRadius;
        this.breakDepth = breakDepth;
    }

    protected String getAOEToolName() {
        return "tool." + this.getToolName().toLowerCase();
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        String toolName = "tool." + this.getAOEToolName().toLowerCase();
        Block block = player.field_70170_p.func_147439_a(x, y, z);
        int meta = player.field_70170_p.func_72805_g(x, y, z);
        if (block == null || !this.isEffective(block, meta) || !stack.func_77942_o()) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        NBTTagCompound toolTags = stack.func_77978_p().func_74775_l("InfiTool");
        if (toolTags == null || toolTags.func_74767_n("Broken")) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        if (player.func_70093_af()) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        MovingObjectPosition mop = AbilityHelper.raytraceFromEntity(player.field_70170_p, (Entity)player, false, 4.5);
        if (mop == null) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        int sideHit = mop.field_72310_e;
        int xRange = this.breakRadius;
        int yRange = this.breakRadius;
        int zRange = this.breakDepth;
        switch (sideHit) {
            case 0: 
            case 1: {
                yRange = this.breakDepth;
                zRange = this.breakRadius;
                break;
            }
            case 2: 
            case 3: {
                xRange = this.breakRadius;
                zRange = this.breakDepth;
                break;
            }
            case 4: 
            case 5: {
                xRange = this.breakDepth;
                zRange = this.breakRadius;
            }
        }
        for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
            for (int yPos = y - yRange; yPos <= y + yRange; ++yPos) {
                for (int zPos = z - zRange; zPos <= z + zRange; ++zPos) {
                    int targetMeta;
                    Block targetBlock;
                    if (xPos == x && yPos == y && zPos == z || AoEExclusionList.isBlockExcluded(toolName, targetBlock = player.field_70170_p.func_147439_a(xPos, yPos, zPos), targetMeta = player.field_70170_p.func_72805_g(xPos, yPos, zPos)) || super.onBlockStartBreak(stack, xPos, yPos, zPos, player)) continue;
                    this.breakExtraBlock(player.field_70170_p, xPos, yPos, zPos, sideHit, player, x, y, z);
                }
            }
        }
        return super.onBlockStartBreak(stack, x, y, z, player);
    }
}

