/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.weaponry.weapons;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import tconstruct.library.weaponry.BowBaseAmmo;
import tconstruct.tools.TinkerTools;
import tconstruct.weaponry.TinkerWeaponry;
import tconstruct.weaponry.ammo.ArrowAmmo;

public class LongBow
extends BowBaseAmmo {
    public LongBow() {
        super(0, "Longbow");
    }

    @Override
    public float minAccuracy(ItemStack itemStack) {
        return 7.5f;
    }

    @Override
    public float maxAccuracy(ItemStack itemStack) {
        return 3.33f;
    }

    @Override
    public float getZoom(ItemStack itemStack) {
        return 1.7f;
    }

    @Override
    protected Entity createProjectile(ItemStack arrows, World world, EntityPlayer player, float speed, float accuracy, float windup) {
        float weight;
        NBTTagCompound tags;
        float matAccuracy;
        if (arrows.func_77973_b() instanceof ArrowAmmo && (accuracy += (100.0f - (matAccuracy = (tags = arrows.func_77978_p().func_74775_l("InfiTool")).func_74760_g("Accuracy"))) / 10.0f / Math.max(1.0f, (weight = tags.func_74760_g("Mass")) - 1.0f)) < 0.0f) {
            accuracy = 0.0f;
        }
        return super.createProjectile(arrows, world, player, speed, accuracy, windup);
    }

    @Override
    public String getIconSuffix(int partType) {
        String string;
        switch (partType) {
            case 0: {
                string = "_bow_top";
                break;
            }
            case 1: {
                string = "_bowstring_broken";
                break;
            }
            case 2: {
                string = "_bowstring";
                break;
            }
            case 3: {
                string = "_bow_bottom";
                break;
            }
            case 4: {
                string = "_bow_grip";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    public String getEffectSuffix() {
        return "_bow_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "longbow";
    }

    @Override
    public int getPartAmount() {
        return 4;
    }

    @Override
    protected boolean animateLayer(int renderPass) {
        return renderPass < 3;
    }

    @Override
    public Item getHeadItem() {
        return TinkerWeaponry.partBowLimb;
    }

    @Override
    public Item getHandleItem() {
        return TinkerWeaponry.bowstring;
    }

    @Override
    public Item getAccessoryItem() {
        return TinkerWeaponry.partBowLimb;
    }

    @Override
    public Item getExtraItem() {
        return TinkerTools.largePlate;
    }
}

