/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import net.glease.tc4tweak.asm.ASMUtils;
import net.glease.tc4tweak.asm.LoadingPlugin;
import net.glease.tc4tweak.asm.TC4Transformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class TileVisNodeVisitor
extends ClassVisitor {
    private static final String FIELD_NAME = "tc4tweaks$loadedLink";
    private static final String FIELD_DESC = "Ljava/util/List;";
    private String name;
    private String superName;

    public TileVisNodeVisitor(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.name = name;
        this.superName = superName;
        super.visit(version, access, name, signature, superName, ASMUtils.arrayAppend(interfaces, "net/glease/tc4tweak/asm/ITileVisNode"));
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ("func_145845_h".equals(name) || "updateEntity".equals(name)) {
            return new UpdateEntityVisitor(this.api, mv);
        }
        return mv;
    }

    public void visitEnd() {
        this.cv.visitField(2, FIELD_NAME, FIELD_DESC, "Ljava/util/List<Lnet/minecraft/util/ChunkCoordinates;>;", null).visitEnd();
        String methodName = LoadingPlugin.dev ? "readFromNBT" : "func_145839_a";
        MethodVisitor mv = this.cv.visitMethod(1, methodName, "(Lnet/minecraft/nbt/NBTTagCompound;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, this.superName, methodName, "(Lnet/minecraft/nbt/NBTTagCompound;)V", false);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, "net/glease/tc4tweak/asm/ASMCallhookServer", "readLoadedLink", "(Lthaumcraft/api/visnet/TileVisNode;Lnet/minecraft/nbt/NBTTagCompound;)Ljava/util/List;", false);
        mv.visitFieldInsn(181, this.name, FIELD_NAME, FIELD_DESC);
        mv.visitInsn(177);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
        TC4Transformer.log.debug("Added {}", new Object[]{methodName});
        methodName = LoadingPlugin.dev ? "writeToNBT" : "func_145841_b";
        mv = this.cv.visitMethod(1, methodName, "(Lnet/minecraft/nbt/NBTTagCompound;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, this.superName, methodName, "(Lnet/minecraft/nbt/NBTTagCompound;)V", false);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, "net/glease/tc4tweak/asm/ASMCallhookServer", "writeLoadedLink", "(Lthaumcraft/api/visnet/TileVisNode;Lnet/minecraft/nbt/NBTTagCompound;)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        TC4Transformer.log.debug("Added {}", new Object[]{methodName});
        methodName = "getSavedLink";
        mv = this.cv.visitMethod(1, methodName, "()Ljava/util/List;", "()Ljava/util/List<Lnet/minecraft/util/ChunkCoordinates;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.name, FIELD_NAME, FIELD_DESC);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        TC4Transformer.log.debug("Added {}", new Object[]{methodName});
        methodName = "clearSavedLink";
        mv = this.cv.visitMethod(1, methodName, "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitInsn(1);
        mv.visitFieldInsn(181, this.name, FIELD_NAME, FIELD_DESC);
        mv.visitInsn(177);
        mv.visitMaxs(2, 1);
        TC4Transformer.log.debug("Added {}", new Object[]{methodName});
        super.visitEnd();
    }

    private static class UpdateEntityVisitor
    extends MethodVisitor {
        private int state;

        public UpdateEntityVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            super.visitFieldInsn(opcode, owner, name, desc);
            if (this.state == 0 && opcode == 180 && name.equals("nodeRefresh")) {
                this.state = 1;
                TC4Transformer.log.trace("Found GETFIELD nodeRefresh");
            }
        }

        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            if (this.state == 1 && opcode == 153) {
                this.state = 2;
            }
        }

        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
            super.visitFrame(type, nLocal, local, nStack, stack);
            if (this.state == 2) {
                TC4Transformer.log.trace("Inserting loadedLink processing by frame insn {}", new Object[]{type});
                this.insert();
            }
        }

        private void insert() {
            this.mv.visitVarInsn(25, 0);
            this.mv.visitMethodInsn(184, "net/glease/tc4tweak/asm/ASMCallhookServer", "processSavedLink", "(Lnet/glease/tc4tweak/asm/ITileVisNode;)Z", false);
            Label label = new Label();
            this.mv.visitJumpInsn(153, label);
            this.mv.visitInsn(177);
            this.mv.visitLabel(label);
            this.mv.visitFrame(3, 0, null, 0, null);
            TC4Transformer.log.trace("Inserted processSavedLink");
            this.state = 3;
        }

        public void visitVarInsn(int opcode, int var) {
            super.visitVarInsn(opcode, var);
            if (this.state == 2) {
                TC4Transformer.log.trace("Inserting loadedLink processing by var insn {}", new Object[]{opcode});
                this.insert();
            }
        }

        public void visitEnd() {
            if (this.state != 3) {
                throw new IllegalStateException("Unexpected state: " + this.state);
            }
            super.visitEnd();
        }
    }
}

