/*
 * Decompiled with CFR 0.152.
 */
package elan.tweaks.common.gui.dto;

import elan.tweaks.common.ext.HexMath;
import elan.tweaks.common.gui.dto.VectorXY;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u000bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lelan/tweaks/common/gui/dto/HexVector;", "", "q", "", "r", "<init>", "(II)V", "getQ", "()I", "getR", "key", "", "getKey", "()Ljava/lang/String;", "toOrigin", "Lelan/tweaks/common/gui/dto/VectorXY;", "hexSize", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "ThaumcraftResearchTweaks"})
public final class HexVector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int q;
    private final int r;
    @NotNull
    private final String key;

    public HexVector(int q, int r) {
        this.q = q;
        this.r = r;
        this.key = "" + this.q + ':' + this.r;
    }

    public final int getQ() {
        return this.q;
    }

    public final int getR() {
        return this.r;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    @NotNull
    public final VectorXY toOrigin(int hexSize) {
        return HexMath.INSTANCE.toOrigin(this.q, this.r, hexSize);
    }

    public final int component1() {
        return this.q;
    }

    public final int component2() {
        return this.r;
    }

    @NotNull
    public final HexVector copy(int q, int r) {
        return new HexVector(q, r);
    }

    public static /* synthetic */ HexVector copy$default(HexVector hexVector, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = hexVector.q;
        }
        if ((n3 & 2) != 0) {
            n2 = hexVector.r;
        }
        return hexVector.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "HexVector(q=" + this.q + ", r=" + this.r + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.q);
        result = result * 31 + Integer.hashCode(this.r);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HexVector)) {
            return false;
        }
        HexVector hexVector = (HexVector)other;
        if (this.q != hexVector.q) {
            return false;
        }
        return this.r == hexVector.r;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ$\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lelan/tweaks/common/gui/dto/HexVector$Companion;", "", "<init>", "()V", "roundedFrom", "Lelan/tweaks/common/gui/dto/HexVector;", "vector", "Lelan/tweaks/common/gui/dto/VectorXY;", "hexSize", "", "findRoundedCoordinates", "Lkotlin/Pair;", "ThaumcraftResearchTweaks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HexVector roundedFrom(@NotNull VectorXY vector, int hexSize) {
            Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
            Pair<Integer, Integer> pair = this.findRoundedCoordinates(vector, hexSize);
            int roundQ = ((Number)pair.component1()).intValue();
            int roundR = ((Number)pair.component2()).intValue();
            return new HexVector(roundQ, roundR);
        }

        private final Pair<Integer, Integer> findRoundedCoordinates(VectorXY vector, int hexSize) {
            double q = 0.6666666666666666 * (double)vector.getX() / (double)hexSize;
            double r = 0.3333333333333333 * (Math.sqrt(3.0) * (double)(-vector.getY()) - (double)vector.getX()) / (double)hexSize;
            double s = -q - r;
            int roundQ = MathKt.roundToInt((double)q);
            int roundR = MathKt.roundToInt((double)r);
            int roundS = MathKt.roundToInt((double)s);
            double deltaQ = Math.abs((double)roundQ - q);
            double deltaR = Math.abs((double)roundR - r);
            double deltaS = Math.abs((double)roundS - s);
            if (deltaQ > deltaR && deltaQ > deltaS) {
                roundQ = -roundR - roundS;
            } else if (deltaR <= deltaS) {
                roundS = -roundQ - roundR;
            }
            return TuplesKt.to((Object)roundQ, (Object)roundS);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

