/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.TFGenericPacketHandler;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.item.TFItems;
import twilightforest.world.ChunkProviderTwilightForest;
import twilightforest.world.WorldProviderTwilightForest;

public class BlockTFCastleDoor
extends Block {
    private IIcon activeIcon;
    private final boolean isVanished;

    public BlockTFCastleDoor(boolean isVanished) {
        super(isVanished ? Material.field_151592_s : Material.field_151576_e);
        this.isVanished = isVanished;
        this.field_149786_r = isVanished ? 0 : 255;
        this.func_149711_c(1.0f);
        if (!isVanished) {
            this.func_149647_a(TFItems.creativeTab);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        if (this.isVanished) {
            this.field_149761_L = register.func_94245_a("TwilightForest:castle_door_vanished");
            this.activeIcon = register.func_94245_a("TwilightForest:castle_door_vanished_active");
        } else {
            this.field_149761_L = register.func_94245_a("TwilightForest:castle_door");
            this.activeIcon = register.func_94245_a("TwilightForest:castle_door_active");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        if (BlockTFCastleDoor.isMetaActive(meta)) {
            return this.activeIcon;
        }
        return this.field_149761_L;
    }

    public boolean func_149662_c() {
        return !this.isVanished;
    }

    public AxisAlignedBB func_149668_a(World par1World, int x, int y, int z) {
        if (this.isVanished) {
            return null;
        }
        this.func_149719_a((IBlockAccess)par1World, x, y, z);
        return super.func_149668_a(par1World, x, y, z);
    }

    public boolean func_149655_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return !this.isVanished;
    }

    public boolean func_149727_a(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        int meta = par1World.func_72805_g(x, y, z);
        if (!BlockTFCastleDoor.isMetaActive(meta)) {
            if (BlockTFCastleDoor.isBlockLocked(par1World, x, y, z)) {
                par1World.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 1.0f, 0.3f);
            } else {
                BlockTFCastleDoor.changeToActiveBlock(par1World, x, y, z, meta);
            }
            return true;
        }
        return false;
    }

    public static void changeToActiveBlock(World par1World, int x, int y, int z, int meta) {
        BlockTFCastleDoor.changeToBlockMeta(par1World, x, y, z, meta | 8);
        BlockTFCastleDoor.playVanishSound(par1World, x, y, z);
        Block blockAt = par1World.func_147439_a(x, y, z);
        par1World.func_147464_a(x, y, z, blockAt, 2 + par1World.field_73012_v.nextInt(5));
    }

    private static void changeToBlockMeta(World par1World, int x, int y, int z, int meta) {
        Block blockAt = par1World.func_147439_a(x, y, z);
        if (blockAt == TFBlocks.castleDoor || blockAt == TFBlocks.castleDoorVanished) {
            par1World.func_147465_d(x, y, z, blockAt, meta, 3);
            par1World.func_147458_c(x, y, z, x, y, z);
            par1World.func_147459_d(x, y, z, blockAt);
        }
    }

    public static boolean isBlockLocked(World par1World, int x, int y, int z) {
        int meta = par1World.func_72805_g(x, y, z);
        if (!par1World.field_72995_K && par1World.field_73011_w instanceof WorldProviderTwilightForest) {
            ChunkProviderTwilightForest chunkProvider = ((WorldProviderTwilightForest)par1World.field_73011_w).getChunkProvider();
            return chunkProvider.isStructureLocked(x, y, z, meta);
        }
        return false;
    }

    public static boolean isMetaActive(int meta) {
        return (meta & 8) != 0;
    }

    public int tickRate() {
        return 5;
    }

    public int func_149645_b() {
        return TwilightForestMod.proxy.getCastleMagicBlockRenderID();
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(itemIn, 1, 0));
        list.add(new ItemStack(itemIn, 1, 1));
        list.add(new ItemStack(itemIn, 1, 2));
        list.add(new ItemStack(itemIn, 1, 3));
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        return Item.func_150898_a((Block)TFBlocks.castleDoor);
    }

    public int func_149692_a(int meta) {
        return meta & 7;
    }

    public void func_149674_a(World par1World, int x, int y, int z, Random par5Random) {
        if (!par1World.field_72995_K) {
            int meta = par1World.func_72805_g(x, y, z);
            if (this.isVanished) {
                if (BlockTFCastleDoor.isMetaActive(meta)) {
                    par1World.func_147465_d(x, y, z, TFBlocks.castleDoor, meta & 7, 3);
                    par1World.func_147459_d(x, y, z, (Block)this);
                    BlockTFCastleDoor.playVanishSound(par1World, x, y, z);
                } else {
                    BlockTFCastleDoor.changeToActiveBlock(par1World, x, y, z, meta);
                }
            } else if (BlockTFCastleDoor.isMetaActive(meta)) {
                par1World.func_147465_d(x, y, z, BlockTFCastleDoor.getOtherBlock(this), meta & 7, 3);
                par1World.func_147464_a(x, y, z, BlockTFCastleDoor.getOtherBlock(this), 80);
                par1World.func_147459_d(x, y, z, (Block)this);
                BlockTFCastleDoor.playReappearSound(par1World, x, y, z);
                par1World.func_147458_c(x, y, z, x, y, z);
                this.sendAnnihilateBlockPacket(par1World, x, y, z);
                BlockTFCastleDoor.checkAndActivateCastleDoor(par1World, x - 1, y, z);
                BlockTFCastleDoor.checkAndActivateCastleDoor(par1World, x + 1, y, z);
                BlockTFCastleDoor.checkAndActivateCastleDoor(par1World, x, y + 1, z);
                BlockTFCastleDoor.checkAndActivateCastleDoor(par1World, x, y - 1, z);
                BlockTFCastleDoor.checkAndActivateCastleDoor(par1World, x, y, z + 1);
                BlockTFCastleDoor.checkAndActivateCastleDoor(par1World, x, y, z - 1);
            }
        }
    }

    private void sendAnnihilateBlockPacket(World world, int x, int y, int z) {
        FMLProxyPacket message = TFGenericPacketHandler.makeAnnihilateBlockPacket(x, y, z);
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, (double)y, (double)z, 64.0);
        TwilightForestMod.genericChannel.sendToAllAround(message, targetPoint);
    }

    private static void playVanishSound(World par1World, int x, int y, int z) {
        par1World.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 0.125f, par1World.field_73012_v.nextFloat() * 0.25f + 1.75f);
    }

    private static void playReappearSound(World par1World, int x, int y, int z) {
        par1World.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 0.125f, par1World.field_73012_v.nextFloat() * 0.25f + 1.25f);
    }

    private static Block getOtherBlock(Block block) {
        return block == TFBlocks.castleDoor ? TFBlocks.castleDoorVanished : TFBlocks.castleDoor;
    }

    public static void checkAndActivateCastleDoor(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block == TFBlocks.castleDoor && !BlockTFCastleDoor.isMetaActive(meta) && !BlockTFCastleDoor.isBlockLocked(world, x, y, z)) {
            BlockTFCastleDoor.changeToActiveBlock(world, x, y, z, meta);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World par1World, int x, int y, int z, Random par5Random) {
        int meta = par1World.func_72805_g(x, y, z);
        if (BlockTFCastleDoor.isMetaActive(meta)) {
            // empty if block
        }
        for (int i = 0; i < 1; ++i) {
        }
    }

    public void sparkle(World world, int x, int y, int z, Random rand) {
        double offset = 0.0625;
        for (int side = 0; side < 6; ++side) {
            double rx = (float)x + rand.nextFloat();
            double ry = (float)y + rand.nextFloat();
            double rz = (float)z + rand.nextFloat();
            if (side == 0 && !world.func_147439_a(x, y + 1, z).func_149662_c()) {
                ry = (double)(y + 1) + offset;
            }
            if (side == 1 && !world.func_147439_a(x, y - 1, z).func_149662_c()) {
                ry = (double)(y + 0) - offset;
            }
            if (side == 2 && !world.func_147439_a(x, y, z + 1).func_149662_c()) {
                rz = (double)(z + 1) + offset;
            }
            if (side == 3 && !world.func_147439_a(x, y, z - 1).func_149662_c()) {
                rz = (double)(z + 0) - offset;
            }
            if (side == 4 && !world.func_147439_a(x + 1, y, z).func_149662_c()) {
                rx = (double)(x + 1) + offset;
            }
            if (side == 5 && !world.func_147439_a(x - 1, y, z).func_149662_c()) {
                rx = (double)(x + 0) - offset;
            }
            if (!(rx < (double)x || rx > (double)(x + 1) || ry < 0.0 || ry > (double)(y + 1) || rz < (double)z) && !(rz > (double)(z + 1))) continue;
            world.func_72869_a("reddust", rx, ry, rz, 0.0, 0.0, 0.0);
        }
    }
}

