/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.api.crafting.IInfusionStabiliser;
import twilightforest.entity.boss.EntityTFHydra;
import twilightforest.entity.boss.EntityTFKnightPhantom;
import twilightforest.entity.boss.EntityTFLich;
import twilightforest.entity.boss.EntityTFMinoshroom;
import twilightforest.entity.boss.EntityTFNaga;
import twilightforest.entity.boss.EntityTFSnowQueen;
import twilightforest.entity.boss.EntityTFUrGhast;
import twilightforest.entity.boss.EntityTFYetiAlpha;
import twilightforest.entity.passive.EntityTFQuestRam;
import twilightforest.item.TFItems;
import twilightforest.tileentity.TileEntityTFTrophy;

@Optional.Interface(iface="thaumcraft.api.crafting.IInfusionStabiliser", modid="Thaumcraft")
public class BlockTFTrophy
extends BlockContainer
implements IInfusionStabiliser {
    public BlockTFTrophy() {
        super(Material.field_151594_q);
        this.func_149672_a(field_149775_l);
        this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.5f, 0.75f);
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        this.func_149719_a((IBlockAccess)par1World, par2, par3, par4);
        return super.func_149668_a(par1World, par2, par3, par4);
    }

    public void func_149719_a(IBlockAccess par1IBlockAccess, int x, int y, int z) {
        int meta = par1IBlockAccess.func_72805_g(x, y, z) & 7;
        TileEntityTFTrophy trophy = (TileEntityTFTrophy)par1IBlockAccess.func_147438_o(x, y, z);
        if (trophy != null && trophy.func_145904_a() == 0) {
            switch (meta) {
                default: {
                    this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.5f, 0.75f);
                    break;
                }
                case 2: 
                case 3: {
                    this.func_149676_a(0.25f, 0.25f, 0.0f, 0.75f, 0.75f, 1.0f);
                    break;
                }
                case 4: 
                case 5: {
                    this.func_149676_a(0.0f, 0.25f, 0.25f, 1.0f, 0.75f, 0.75f);
                    break;
                }
            }
        } else if (trophy != null && trophy.func_145904_a() == 3) {
            this.func_149676_a(0.25f, 0.5f, 0.25f, 0.75f, 1.0f, 0.75f);
        } else if (trophy != null && trophy.func_145904_a() == 7) {
            float pixel = 0.0625f;
            switch (meta) {
                default: {
                    this.func_149676_a(pixel * 3.2f, 0.0f, pixel * 3.2f, 1.0f - pixel * 3.2f, 0.665f, 1.0f - pixel * 3.2f);
                    break;
                }
                case 2: {
                    this.func_149676_a(pixel * 3.2f, pixel * 4.0f, pixel * 4.4f * 2.0f, 1.0f - pixel * 3.2f, 0.67f + pixel * 4.0f, 1.0f);
                    break;
                }
                case 3: {
                    this.func_149676_a(pixel * 3.2f, pixel * 4.0f, 0.0f, 1.0f - pixel * 3.2f, 0.67f + pixel * 4.0f, 1.0f - pixel * 4.4f * 2.0f);
                    break;
                }
                case 4: {
                    this.func_149676_a(pixel * 4.4f * 2.0f, pixel * 4.0f, pixel * 3.2f, 1.0f, 0.67f + pixel * 4.0f, 1.0f - pixel * 3.2f);
                    break;
                }
                case 5: {
                    this.func_149676_a(0.0f, pixel * 4.0f, pixel * 3.2f, 1.0f - pixel * 4.4f * 2.0f, 0.67f + pixel * 4.0f, 1.0f - pixel * 3.2f);
                    break;
                }
            }
        } else {
            switch (meta) {
                default: {
                    this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.5f, 0.75f);
                    break;
                }
                case 2: {
                    this.func_149676_a(0.25f, 0.25f, 0.5f, 0.75f, 0.75f, 1.0f);
                    break;
                }
                case 3: {
                    this.func_149676_a(0.25f, 0.25f, 0.0f, 0.75f, 0.75f, 0.5f);
                    break;
                }
                case 4: {
                    this.func_149676_a(0.5f, 0.25f, 0.25f, 1.0f, 0.75f, 0.75f);
                    break;
                }
                case 5: {
                    this.func_149676_a(0.0f, 0.25f, 0.25f, 0.5f, 0.75f, 0.75f);
                }
            }
        }
    }

    public void func_149689_a(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLiving, ItemStack itemStack) {
        int rotation = MathHelper.func_76128_c((double)((double)(par5EntityLiving.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3;
        par1World.func_72921_c(par2, par3, par4, rotation, 2);
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityTFTrophy();
    }

    @SideOnly(value=Side.CLIENT)
    public Item idPicked(World par1World, int par2, int par3, int par4) {
        return TFItems.trophy;
    }

    public int func_149643_k(World par1World, int par2, int par3, int par4) {
        TileEntity var5 = par1World.func_147438_o(par2, par3, par4);
        return var5 != null && var5 instanceof TileEntitySkull ? ((TileEntitySkull)var5).func_145904_a() : super.func_149643_k(par1World, par2, par3, par4);
    }

    public int func_149692_a(int par1) {
        return par1;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World p_149694_1_, int p_149694_2_, int p_149694_3_, int p_149694_4_) {
        return TFItems.trophy;
    }

    public void func_149681_a(World par1World, int par2, int par3, int par4, int par5, EntityPlayer par6EntityPlayer) {
        if (par6EntityPlayer.field_71075_bZ.field_75098_d) {
            par1World.func_72921_c(par2, par3, par4, par5 |= 8, 2);
        }
        this.func_149697_b(par1World, par2, par3, par4, par5, 0);
        super.func_149681_a(par1World, par2, par3, par4, par5, par6EntityPlayer);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if ((metadata & 8) == 0) {
            ItemStack var7 = new ItemStack(TFItems.trophy, 1, this.func_149643_k(world, x, y, z));
            TileEntityTFTrophy var8 = (TileEntityTFTrophy)world.func_147438_o(x, y, z);
            if (var8 == null) {
                return drops;
            }
            drops.add(var7);
        }
        return drops;
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return TFItems.trophy;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return Blocks.field_150425_aM.func_149691_a(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
    }

    public boolean func_149727_a(World worldIn, int x, int y, int z, EntityPlayer player, int side, float subX, float subY, float subZ) {
        String sound;
        if (player.func_70093_af() && player.field_71071_by.field_70460_b[3] == null) {
            player.field_71071_by.field_70460_b[3] = new ItemStack(TFItems.trophy, 1, this.func_149643_k(worldIn, x, y, z));
            if (!player.field_71075_bZ.field_75098_d) {
                worldIn.func_147468_f(x, y, z);
            }
            return true;
        }
        switch (((TileEntitySkull)worldIn.func_147438_o(x, y, z)).func_145904_a()) {
            default: {
                sound = new EntityTFHydra(worldIn).getTrophySound();
                break;
            }
            case 1: {
                sound = new EntityTFNaga(worldIn).getTrophySound();
                break;
            }
            case 2: {
                sound = new EntityTFLich(worldIn).getTrophySound();
                break;
            }
            case 3: {
                sound = new EntityTFUrGhast(worldIn).getTrophySound();
                break;
            }
            case 4: {
                sound = new EntityTFSnowQueen(worldIn).getTrophySound();
                break;
            }
            case 5: {
                sound = new EntityTFMinoshroom(worldIn).getTrophySound();
                break;
            }
            case 6: {
                sound = new EntityTFKnightPhantom(worldIn).getTrophySound();
                break;
            }
            case 7: {
                sound = new EntityTFYetiAlpha(worldIn).getTrophySound();
                break;
            }
            case 8: {
                sound = new EntityTFQuestRam(worldIn).getTrophySound();
            }
        }
        worldIn.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, sound, 1.0f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
        return true;
    }

    public boolean canStabaliseInfusion(World world, int x, int y, int z) {
        return true;
    }
}

