/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.authlib.GameProfile;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import lain.mods.skinport.init.forge.ClientProxy;
import lain.mods.skins.api.SkinProviderAPI;
import lain.mods.skins.api.interfaces.IPlayerProfile;
import lain.mods.skins.api.interfaces.ISkin;
import lain.mods.skins.impl.PlayerProfile;
import lain.mods.skins.impl.SkinData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;

public class RenderTFGiantSkinportIntegration {
    public static ResourceLocation getSkin(EntityClientPlayerMP player, ResourceLocation skin, ResourceLocation textureLoc) {
        ISkin iskin;
        ResourceLocation skin1 = ClientProxy.bindTexture((GameProfile)Minecraft.func_71410_x().field_71439_g.func_146103_bH(), (ResourceLocation)skin);
        GameProfile profile = player.func_146103_bH();
        if (profile != null && (iskin = SkinProviderAPI.SKIN.getSkin((IPlayerProfile)PlayerProfile.wrapGameProfile((GameProfile)profile))) != null && iskin.isDataReady()) {
            ByteBuffer data = iskin.getData();
            try (InputStream in = SkinData.wrapByteBufferAsInputStream((ByteBuffer)data);
                 ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                BufferedImage bufferedImage = ImageIO.read(in);
                if (bufferedImage != null) {
                    if (bufferedImage.getWidth() == bufferedImage.getHeight()) {
                        bufferedImage = bufferedImage.getSubimage(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight() / 2);
                    }
                    skin1 = Minecraft.func_71410_x().func_110434_K().func_110578_a(" ", new DynamicTexture(bufferedImage));
                }
            }
            catch (Throwable t) {
                skin1 = textureLoc;
            }
        }
        return skin1;
    }

    public static boolean isSlim(EntityClientPlayerMP player) {
        GameProfile profile = player.func_146103_bH();
        if (profile != null) {
            ISkin iskin = SkinProviderAPI.SKIN.getSkin((IPlayerProfile)PlayerProfile.wrapGameProfile((GameProfile)profile));
            return iskin.getSkinType() == "slim";
        }
        return false;
    }
}

