/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.core.ClientUtils;
import codechicken.core.ServerUtils;
import codechicken.wirelessredstone.addons.EntityWirelessTracker;
import codechicken.wirelessredstone.addons.RedstoneEtherAddons;
import codechicken.wirelessredstone.addons.RemoteTexManager;
import codechicken.wirelessredstone.addons.TriangTexManager;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class WRAddonEventHandler {
    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        RedstoneEtherAddons.server().onLogin(event.player);
    }

    @SubscribeEvent
    public void playerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        RedstoneEtherAddons.server().onLogout(event.player);
    }

    @SubscribeEvent
    public void playerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        RedstoneEtherAddons.server().onDimensionChange(event.player);
    }

    @SubscribeEvent
    public void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        RedstoneEtherAddons.server().onLogin(event.player);
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            RedstoneEtherAddons.server().processSMPMaps(event.world);
        }
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (RedstoneEtherAddons.server() == null) {
            RedstoneEtherAddons.loadServerWorld();
        }
        if (event.phase == TickEvent.Phase.START) {
            RedstoneEtherAddons.server().processTrackers();
        } else {
            RedstoneEtherAddons.server().tickTriangs();
            RedstoneEtherAddons.server().updateREPTimeouts();
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (ClientUtils.inWorld()) {
            if (event.phase == TickEvent.Phase.START) {
                TriangTexManager.processAllTextures();
            } else {
                RedstoneEtherAddons.client().tick();
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.world.field_72995_K) {
            RedstoneEtherAddons.loadClientManager();
        } else {
            RedstoneEtherAddons.loadServerWorld();
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        Chunk chunk = event.getChunk();
        for (int i = 0; i < chunk.field_76645_j.length; ++i) {
            for (int j = 0; j < chunk.field_76645_j[i].size(); ++j) {
                Object o = chunk.field_76645_j[i].get(j);
                if (!(o instanceof EntityWirelessTracker)) continue;
                ((EntityWirelessTracker)o).onChunkUnload();
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureLoad(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 1) {
            RemoteTexManager.load(event.map);
            TriangTexManager.loadTextures();
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (!ServerUtils.mc().func_71278_l()) {
            RedstoneEtherAddons.unloadServer();
        }
    }
}

