/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.stevescarts;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class HUDLiquidManager
implements IWailaDataProvider {
    private static String[] colors = new String[]{"NA", "Red", "Blue", "Yellow", "Green", "Dis."};
    private static String[] sides = new String[]{"Yellow", "Blue", "Green", "Red"};

    @Override
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    @Override
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        int side;
        if (!config.getConfig("stevescarts.showall")) {
            return currenttip;
        }
        if (config.getConfig("stevescarts.shifttoggle") && !accessor.getPlayer().func_70093_af()) {
            currenttip.add(SpecialChars.ITALIC + "Press shift for more data");
            return currenttip;
        }
        NBTTagCompound tag = accessor.getNBTData();
        if (config.getConfig("stevescarts.colorblind") && (side = accessor.getSide().ordinal() - 2) >= 0) {
            currenttip.add("Looking at side " + SpecialChars.WHITE + sides[side]);
        }
        int layout = accessor.getNBTInteger(tag, "layout");
        switch (layout) {
            case 0: {
                currenttip.add("Tanks : " + SpecialChars.WHITE + "Shared");
                break;
            }
            case 1: {
                currenttip.add("Tanks : " + SpecialChars.WHITE + "By side");
                break;
            }
            case 2: {
                currenttip.add("Tanks : " + SpecialChars.WHITE + "By color");
            }
        }
        int toCart = accessor.getNBTInteger(tag, "tocart");
        int doReturn = accessor.getNBTInteger(tag, "doReturn");
        for (int i = 0; i < 4; ++i) {
            String fluidString;
            int color = accessor.getNBTInteger(tag, "color" + i);
            int amount = accessor.getNBTInteger(tag, "amount" + i);
            String fluidName = "<Empty>";
            int fluidAmount = 0;
            if (tag.func_74764_b("Fluid" + i)) {
                fluidName = tag.func_74775_l("Fluid" + i).func_74779_i("FluidName");
                fluidAmount = tag.func_74775_l("Fluid" + i).func_74762_e("Amount");
            }
            String string = fluidString = fluidAmount == 0 ? "<Empty>" : String.format("%s mB of %s", fluidAmount, fluidName);
            if (color == 5) continue;
            String direction = (toCart & 1 << i) != 0 ? "Load" : "Unload";
            String shouldReturn = (doReturn & 1 << i) != 0 ? "Ret." : "Cont.";
            String sAmount = amount == 0 ? "All" : this.getMaxAmountBuckets(amount) + " mB";
            currenttip.add(String.format("Side %s %s[ %s ]%s[ %s , %s]%s[ %s ]", SpecialChars.WHITE + colors[color] + SpecialChars.GRAY, SpecialChars.TAB + SpecialChars.ALIGNRIGHT, SpecialChars.WHITE + fluidString + SpecialChars.GRAY, SpecialChars.TAB + SpecialChars.ALIGNRIGHT, SpecialChars.WHITE + direction + SpecialChars.GRAY, SpecialChars.TAB + SpecialChars.ALIGNRIGHT + SpecialChars.WHITE + shouldReturn + SpecialChars.GRAY, SpecialChars.TAB + SpecialChars.ALIGNRIGHT, SpecialChars.WHITE + sAmount + SpecialChars.GRAY));
        }
        return currenttip;
    }

    @Override
    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public int getMaxAmountBuckets(int id) {
        int n;
        switch (id) {
            case 1: {
                n = 250;
                break;
            }
            case 2: {
                n = 500;
                break;
            }
            case 3: {
                n = 750;
                break;
            }
            case 4: {
                n = 1000;
                break;
            }
            case 5: {
                n = 2000;
                break;
            }
            case 6: {
                n = 3000;
                break;
            }
            case 7: {
                n = 5000;
                break;
            }
            case 8: {
                n = 7500;
                break;
            }
            case 9: {
                n = 10000;
                break;
            }
            case 10: {
                n = 15000;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @Override
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te != null) {
            te.func_145841_b(tag);
        }
        return tag;
    }
}

