/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.blocks;

import eu.usrv.yamcore.YAMCore;
import eu.usrv.yamcore.auxiliary.LogHelper;
import eu.usrv.yamcore.blocks.BlockBase;
import eu.usrv.yamcore.iface.IExtendedBlockProperties;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;

public class ModSimpleBaseBlock {
    private final String _mName;
    private String _mTextureOverride;
    private final BlockBase _mBlockInstance;
    private String _mCreativeTab;
    private LogHelper _mLog = YAMCore.instance.getLogger();
    private boolean _mFullyPopulated = false;

    public ModSimpleBaseBlock(Material pBlockBaseMaterial, String pBlockName, String pCustomTextureName, String pCreativeTabName) {
        this._mName = pBlockName;
        this._mCreativeTab = pCreativeTabName;
        this._mTextureOverride = pCustomTextureName;
        this._mBlockInstance = new BlockBase(pBlockBaseMaterial);
        this._mBlockInstance.func_149663_c(pBlockName);
    }

    public ModSimpleBaseBlock(IExtendedBlockProperties pBlockProperties, String pCreativeTabName) {
        this._mName = pBlockProperties.getBlockName();
        this._mCreativeTab = pCreativeTabName;
        this._mTextureOverride = pBlockProperties.getTextureName();
        this._mBlockInstance = new BlockBase(pBlockProperties.getMaterial());
        this._mBlockInstance.func_149663_c(this._mName);
        if (pBlockProperties.getUnbreakable()) {
            this._mBlockInstance.func_149722_s();
        } else {
            this._mBlockInstance.func_149711_c(pBlockProperties.getHardness());
            this._mBlockInstance.setHarvestLevel(pBlockProperties.getHarvestToolClass(), pBlockProperties.getHarvestLevel());
            this._mBlockInstance.func_149752_b(pBlockProperties.getResistance());
        }
        this._mBlockInstance.func_149672_a(pBlockProperties.getStepSound());
        this._mBlockInstance.func_149715_a(pBlockProperties.getLightLevel());
        this._mBlockInstance.func_149713_g(pBlockProperties.getOpacity());
        this._mBlockInstance.setInner_IsOpaque(pBlockProperties.getIsOpaqueCube());
    }

    public ModSimpleBaseBlock(Material pBlockBaseMaterial, String pBlockName, String pCreativeTabName) {
        this(pBlockBaseMaterial, pBlockName, "", pCreativeTabName);
    }

    public void setModIDName(String pModID) {
        String tTextureName = "";
        tTextureName = this._mTextureOverride.length() < 1 ? String.format("%s:block%s", pModID, this._mName) : this._mTextureOverride;
        this._mBlockInstance.func_149658_d(tTextureName);
        this._mFullyPopulated = true;
    }

    public BlockBase getConstructedBlock() {
        if (!this._mFullyPopulated) {
            this._mLog.error("Block is not fully prepared yet and can't be registered at this point!");
            return null;
        }
        return this._mBlockInstance;
    }

    public void setCreativeTab(CreativeTabs pTab) {
        this._mBlockInstance.func_149647_a(pTab);
    }

    public String getCreativeTabName() {
        return this._mCreativeTab;
    }

    public String getUnlocItemName() {
        return this._mName;
    }
}

