/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.persisteddata;

import com.google.common.io.Files;
import eu.usrv.yamcore.YAMCore;
import eu.usrv.yamcore.auxiliary.IntHelper;
import eu.usrv.yamcore.auxiliary.LogHelper;
import eu.usrv.yamcore.iface.IPersistedDataBase;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;

public class PersistedDataBase
implements IPersistedDataBase {
    private Map<String, String> _mDataStorage;
    private String _mBufferFileName;
    private File _mConfigBaseDirectory;
    private LogHelper _mLog = YAMCore.instance.getLogger();
    private String _mModCollection = "";

    public PersistedDataBase(File pConfigBaseDirectory, String pBufferFileName, String pModCollectionDirectory) {
        this._mConfigBaseDirectory = pConfigBaseDirectory;
        this._mBufferFileName = pBufferFileName;
        this._mDataStorage = new HashMap<String, String>();
        this._mModCollection = pModCollectionDirectory;
    }

    @Override
    public void setValue(String pConfigName, String pConfigValue) {
        this._mLog.debug(String.format("Setting persisted config [%s] to value [%s]", pConfigName, pConfigValue));
        this._mDataStorage.put(pConfigName, pConfigValue);
        this.Save();
    }

    @Override
    public void setValue(String pConfigName, int pConfigValue) {
        this.setValue(pConfigName, String.format("%d", pConfigValue));
    }

    @Override
    public int getValueAsInt(String pConfigName, int pDefaultValueOnNull) {
        String tCfgValue = this.getValue(pConfigName);
        if (tCfgValue == null) {
            return pDefaultValueOnNull;
        }
        if (IntHelper.tryParse(tCfgValue)) {
            return Integer.parseInt(tCfgValue);
        }
        return pDefaultValueOnNull;
    }

    @Override
    public String getValue(String pConfigName) {
        return this._mDataStorage.get(pConfigName);
    }

    private File getStorageFile() {
        File tDirectory = new File(this._mConfigBaseDirectory, this._mModCollection);
        if (!tDirectory.exists()) {
            tDirectory.mkdir();
        }
        File tConfigFileObject = new File(tDirectory, this._mBufferFileName);
        return tConfigFileObject;
    }

    @Override
    public boolean Load() {
        File tInputFile = this.getStorageFile();
        boolean tResult = this.LoadFile(tInputFile);
        if (tResult && tInputFile.exists()) {
            this._mLog.info("Creating backup of currently working storage file...");
            File tBackupFile = new File(tInputFile.getAbsolutePath() + ".backup");
            if (tBackupFile.exists()) {
                tBackupFile.delete();
            }
            try {
                Files.copy((File)tInputFile, (File)tBackupFile);
            }
            catch (IOException e) {
                this._mLog.error("Unable to create backup of storage file");
                e.printStackTrace();
            }
        }
        return tResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean LoadFile(File pInputFile) {
        boolean tResult = false;
        this._mLog.debug("Loading persisted storage file...");
        if (!pInputFile.exists()) {
            this._mLog.info("Persisted storage file does not exist. Creating a new one");
            this.Save();
        }
        try {
            FileInputStream file = new FileInputStream(pInputFile);
            BufferedInputStream buffer = new BufferedInputStream(file);
            try (ObjectInputStream input = new ObjectInputStream(buffer);){
                this._mDataStorage = (HashMap)input.readObject();
                tResult = true;
            }
        }
        catch (FileNotFoundException file) {
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return tResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Save() {
        File tInputFile = this.getStorageFile();
        try {
            FileOutputStream file = new FileOutputStream(tInputFile);
            BufferedOutputStream buffer = new BufferedOutputStream(file);
            try (ObjectOutputStream output = new ObjectOutputStream(buffer);){
                output.writeObject(this._mDataStorage);
            }
        }
        catch (FileNotFoundException file) {
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }
}

