/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.inventory;

import com.darkona.adventurebackpack.common.Constants;
import com.darkona.adventurebackpack.config.ConfigHandler;
import com.darkona.adventurebackpack.inventory.ContainerAdventure;
import com.darkona.adventurebackpack.inventory.IInventoryBackpack;
import com.darkona.adventurebackpack.inventory.InventoryActions;
import com.darkona.adventurebackpack.inventory.InventoryCraftingBackpack;
import com.darkona.adventurebackpack.inventory.SlotBackpack;
import com.darkona.adventurebackpack.inventory.SlotCraftMatrix;
import com.darkona.adventurebackpack.inventory.SlotCraftResult;
import com.darkona.adventurebackpack.inventory.SlotFluid;
import com.darkona.adventurebackpack.inventory.SlotTool;
import com.darkona.adventurebackpack.util.TinkersUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.fluids.FluidTank;

public class ContainerBackpack
extends ContainerAdventure {
    private static final int BACK_INV_ROWS = 6;
    private static final int BACK_INV_COLUMNS = 8;
    private static final int BACK_INV_START = 36;
    private static final int BACK_INV_END = 83;
    private static final int TOOL_START = 84;
    private static final int TOOL_END = 85;
    private static final int BUCKET_LEFT = 86;
    private static final int BUCKET_RIGHT = 88;
    private static final int MATRIX_DIMENSION = 3;
    private static final int CRAFT_RESULT = 99;
    private static final int[] CRAFT_MATRIX_EMULATION = ContainerBackpack.findCraftMatrixEmulationIDs();
    private final InventoryCraftingBackpack craftMatrix = new InventoryCraftingBackpack(this, 3, 3);
    private final IInventory craftResult = new InventoryCraftResult();

    public ContainerBackpack(EntityPlayer player, IInventoryBackpack backpack, Constants.Source source) {
        super(player, backpack, source);
        this.makeSlots(player.field_71071_by);
        this.inventory.func_70295_k_();
    }

    public IInventoryBackpack getInventoryBackpack() {
        return (IInventoryBackpack)this.inventory;
    }

    private void makeSlots(InventoryPlayer invPlayer) {
        int col;
        int row;
        this.bindPlayerInventory(invPlayer, 44, 125);
        int startX = 62;
        int startY = 7;
        for (row = 0; row < 6; ++row) {
            for (col = 0; col < 8; ++col) {
                this.func_75146_a(new SlotBackpack(this.inventory, row * 8 + col, startX + 18 * col, startY + 18 * row));
            }
        }
        this.func_75146_a(new SlotTool(this.inventory, 48, 44, 79));
        this.func_75146_a(new SlotTool(this.inventory, 49, 44, 97));
        this.func_75146_a(new SlotFluid(this.inventory, 50, 6, 7));
        this.func_75146_a(new SlotFluid(this.inventory, 51, 6, 37));
        this.func_75146_a(new SlotFluid(this.inventory, 52, 226, 7));
        this.func_75146_a(new SlotFluid(this.inventory, 53, 226, 37));
        startX = 215;
        startY = -2500;
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 3; ++col) {
                this.func_75146_a(new SlotCraftMatrix((IInventory)this.craftMatrix, row * 3 + col, startX + 18 * col, startY + 18 * row));
            }
        }
        this.func_75146_a((Slot)new SlotCraftResult(this, invPlayer.field_70458_d, (IInventory)this.craftMatrix, this.craftResult, 0, 226, 97));
        this.syncCraftMatrixWithInventory(true);
    }

    @Override
    public void func_75142_b() {
        this.syncCraftMatrixWithInventory(true);
        this.syncCraftResultToServer();
        super.func_75142_b();
    }

    private void syncCraftResultToServer() {
        ItemStack stackA = ((Slot)this.field_75151_b.get(99)).func_75211_c();
        ItemStack stackB = (ItemStack)this.field_75153_a.get(99);
        if (!ItemStack.func_77989_b((ItemStack)stackB, (ItemStack)stackA)) {
            stackB = stackA == null ? null : stackA.func_77946_l();
            this.field_75153_a.set(99, stackB);
            if (this.player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)this.player).func_71110_a((Container)this, this.func_75138_a());
            }
        }
    }

    @Override
    protected boolean transferStackToPack(ItemStack stack) {
        if (SlotTool.isValidTool(stack)) {
            if (!this.mergeToolSlot(stack) && SlotBackpack.isValidItem(stack)) {
                return this.mergeBackpackInv(stack);
            }
        } else {
            if (SlotFluid.isContainer(stack) && !this.isHoldingSpace()) {
                return this.transferFluidContainer(stack);
            }
            if (SlotBackpack.isValidItem(stack)) {
                return this.mergeBackpackInv(stack);
            }
        }
        return true;
    }

    private boolean mergeToolSlot(ItemStack stack) {
        return this.func_75135_a(stack, 84, 86, false);
    }

    private boolean mergeBackpackInv(ItemStack stack) {
        return this.func_75135_a(stack, 36, 84, false);
    }

    private boolean mergeLeftBucket(ItemStack stack) {
        return this.func_75135_a(stack, 86, 87, false);
    }

    private boolean mergeRightBucket(ItemStack stack) {
        return this.func_75135_a(stack, 88, 89, false);
    }

    private boolean isHoldingSpace() {
        return this.getInventoryBackpack().getExtendedProperties().func_74764_b("holdingSpace");
    }

    private boolean transferFluidContainer(ItemStack container) {
        FluidTank leftTank = this.getInventoryBackpack().getLeftTank();
        FluidTank rightTank = this.getInventoryBackpack().getRightTank();
        ItemStack leftStackOut = this.func_75139_a(87).func_75211_c();
        ItemStack rightStackOut = this.func_75139_a(89).func_75211_c();
        boolean isLeftTankEmpty = SlotFluid.isEmpty(leftTank);
        boolean isRightTankEmpty = SlotFluid.isEmpty(rightTank);
        boolean suitableToLeft = SlotFluid.isEqualAndCanFit(container, leftTank);
        boolean suitableToRight = SlotFluid.isEqualAndCanFit(container, rightTank);
        boolean areLeftSameType = InventoryActions.areContainersOfSameType(container, leftStackOut);
        boolean areRightSameType = InventoryActions.areContainersOfSameType(container, rightStackOut);
        if (SlotFluid.isFilled(container)) {
            if (isLeftTankEmpty) {
                if (!isRightTankEmpty && suitableToRight && (rightStackOut == null || areRightSameType)) {
                    return this.mergeRightBucket(container);
                }
                if (leftStackOut == null || areLeftSameType) {
                    return this.mergeLeftBucket(container);
                }
            } else {
                if (suitableToLeft && (leftStackOut == null || areLeftSameType)) {
                    return this.mergeLeftBucket(container);
                }
                if ((isRightTankEmpty || suitableToRight) && (rightStackOut == null || areRightSameType)) {
                    return this.mergeRightBucket(container);
                }
                if (leftStackOut == null && rightStackOut == null && SlotBackpack.isValidItem(container)) {
                    return this.mergeBackpackInv(container);
                }
            }
        } else if (SlotFluid.isEmpty(container)) {
            if (isLeftTankEmpty) {
                if (!isRightTankEmpty && (rightStackOut == null || areRightSameType)) {
                    return this.mergeRightBucket(container);
                }
                if (leftStackOut == null && rightStackOut == null && SlotBackpack.isValidItem(container)) {
                    return this.mergeBackpackInv(container);
                }
            } else if (leftStackOut == null || areLeftSameType) {
                return this.mergeLeftBucket(container);
            }
        }
        return false;
    }

    @Override
    public ItemStack func_75144_a(int slot, int button, int flag, EntityPlayer player) {
        ItemStack result = super.func_75144_a(slot, button, flag, player);
        this.syncCraftMatrixWithInventory(true);
        return result;
    }

    @Override
    protected void dropContentOnClose() {
        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            this.craftMatrix.setInventorySlotContentsNoUpdate(i, null);
        }
        this.func_75130_a((IInventory)this.craftMatrix);
        super.dropContentOnClose();
    }

    public void func_75130_a(IInventory inventory) {
        if (ConfigHandler.tinkerToolsMaintenance && TinkersUtils.isToolOrWeapon(this.craftMatrix.func_70301_a(4))) {
            this.craftResult.func_70299_a(0, TinkersUtils.getTinkersRecipe(this.craftMatrix));
        } else {
            this.craftResult.func_70299_a(0, CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)this.craftMatrix, this.player.field_70170_p));
        }
    }

    protected void syncCraftMatrixWithInventory(boolean preCraft) {
        boolean changesMade = false;
        for (int craftSlotID = 0; craftSlotID < CRAFT_MATRIX_EMULATION.length; ++craftSlotID) {
            ItemStack craftStack;
            int invSlotID = CRAFT_MATRIX_EMULATION[craftSlotID];
            ItemStack invStack = this.inventory.func_70301_a(invSlotID);
            if (ItemStack.func_77989_b((ItemStack)invStack, (ItemStack)(craftStack = this.craftMatrix.func_70301_a(craftSlotID)))) continue;
            if (preCraft) {
                craftStack = invStack == null ? null : invStack.func_77946_l();
                this.craftMatrix.setInventorySlotContentsNoUpdate(craftSlotID, craftStack);
            } else {
                invStack = craftStack == null ? null : craftStack.func_77946_l();
                this.inventory.setInventorySlotContentsNoSave(invSlotID, invStack);
            }
            changesMade = true;
        }
        if (changesMade) {
            if (preCraft) {
                this.func_75130_a((IInventory)this.craftMatrix);
            } else {
                this.inventory.func_70296_d();
            }
        }
    }

    private static int[] findCraftMatrixEmulationIDs() {
        int[] slotsArray = new int[9];
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                int id = row * 3 + col;
                int fullRowSum = (4 + row) * 8;
                int columnShift = 2 - col;
                slotsArray[id] = fullRowSum - columnShift - 1;
            }
        }
        return slotsArray;
    }
}

