/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.util;

import com.darkona.adventurebackpack.init.ModItems;
import com.darkona.adventurebackpack.inventory.IInventoryTanks;
import com.darkona.adventurebackpack.inventory.InventoryBackpack;
import com.darkona.adventurebackpack.inventory.InventoryCoalJetpack;
import com.darkona.adventurebackpack.inventory.InventoryCopterPack;
import com.darkona.adventurebackpack.item.IBackWearableItem;
import com.darkona.adventurebackpack.item.ItemAdventureBackpack;
import com.darkona.adventurebackpack.item.ItemAdventureHat;
import com.darkona.adventurebackpack.item.ItemCoalJetpack;
import com.darkona.adventurebackpack.item.ItemCopterPack;
import com.darkona.adventurebackpack.item.ItemHose;
import com.darkona.adventurebackpack.item.ItemPistonBoots;
import com.darkona.adventurebackpack.playerProperties.BackpackProperty;
import com.darkona.adventurebackpack.reference.BackpackTypes;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class Wearing {
    public static boolean isWearingWearable(EntityPlayer player) {
        ItemStack wearable = BackpackProperty.get(player).getWearable();
        if (wearable != null) {
            return wearable.func_77973_b() instanceof IBackWearableItem;
        }
        return false;
    }

    public static ItemStack getWearingWearable(EntityPlayer player) {
        ItemStack wearable = BackpackProperty.get(player).getWearable();
        if (wearable != null && wearable.func_77973_b() instanceof IBackWearableItem) {
            return wearable;
        }
        return null;
    }

    public static WearableType getWearingWearableType(EntityPlayer player) {
        ItemStack wearable = BackpackProperty.get(player).getWearable();
        if (wearable != null && wearable.func_77973_b() instanceof IBackWearableItem) {
            return WearableType.get(wearable);
        }
        return WearableType.UNKNOWN;
    }

    public static IInventoryTanks getWearingWearableInv(EntityPlayer player) {
        ItemStack wearable = Wearing.getWearingWearable(player);
        if (wearable != null) {
            if (wearable.func_77973_b() instanceof ItemAdventureBackpack) {
                return new InventoryBackpack(wearable);
            }
            if (wearable.func_77973_b() instanceof ItemCoalJetpack) {
                return new InventoryCoalJetpack(wearable);
            }
            if (wearable.func_77973_b() instanceof ItemCopterPack) {
                return new InventoryCopterPack(wearable);
            }
        }
        return null;
    }

    public static boolean isHoldingWearable(EntityPlayer player) {
        return player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() instanceof IBackWearableItem;
    }

    public static boolean isWearingBackpack(EntityPlayer player) {
        ItemStack wearable = BackpackProperty.get(player).getWearable();
        if (wearable != null) {
            return wearable.func_77973_b() instanceof ItemAdventureBackpack;
        }
        return false;
    }

    public static boolean isWearingTheRightBackpack(EntityPlayer player, BackpackTypes ... backpacks) {
        ItemStack backpack = Wearing.getWearingBackpack(player);
        if (backpack != null) {
            BackpackTypes backPackType = BackpackTypes.getType(backpack);
            for (BackpackTypes type : backpacks) {
                if (backPackType != type) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemStack getWearingBackpack(EntityPlayer player) {
        ItemStack wearable = BackpackProperty.get(player).getWearable();
        if (wearable != null && wearable.func_77973_b() instanceof ItemAdventureBackpack) {
            return wearable;
        }
        return null;
    }

    public static InventoryBackpack getWearingBackpackInv(EntityPlayer player) {
        return new InventoryBackpack(BackpackProperty.get(player).getWearable());
    }

    public static boolean isHoldingBackpack(EntityPlayer player) {
        return player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemAdventureBackpack;
    }

    public static ItemStack getHoldingBackpack(EntityPlayer player) {
        return Wearing.isHoldingBackpack(player) ? player.field_71071_by.func_70448_g() : null;
    }

    public static InventoryBackpack getHoldingBackpackInv(EntityPlayer player) {
        return new InventoryBackpack(player.func_71045_bC());
    }

    public static boolean isWearingCopter(EntityPlayer player) {
        ItemStack wearable = BackpackProperty.get(player).getWearable();
        if (wearable != null) {
            return wearable.func_77973_b() instanceof ItemCopterPack;
        }
        return false;
    }

    public static ItemStack getWearingCopter(EntityPlayer player) {
        ItemStack wearable = BackpackProperty.get(player).getWearable();
        if (wearable != null && wearable.func_77973_b() instanceof ItemCopterPack) {
            return wearable;
        }
        return null;
    }

    public static boolean isHoldingCopter(EntityPlayer player) {
        return player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemCopterPack;
    }

    public static ItemStack getHoldingCopter(EntityPlayer player) {
        return Wearing.isHoldingCopter(player) ? player.field_71071_by.func_70448_g() : null;
    }

    public static boolean isWearingJetpack(EntityPlayer player) {
        ItemStack wearable = BackpackProperty.get(player).getWearable();
        if (wearable != null) {
            return wearable.func_77973_b() instanceof ItemCoalJetpack;
        }
        return false;
    }

    public static ItemStack getWearingJetpack(EntityPlayer player) {
        ItemStack wearable = BackpackProperty.get(player).getWearable();
        if (wearable != null && wearable.func_77973_b() instanceof ItemCoalJetpack) {
            return wearable;
        }
        return null;
    }

    public static boolean isHoldingJetpack(EntityPlayer player) {
        return player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemCoalJetpack;
    }

    public static ItemStack getHoldingJetpack(EntityPlayer player) {
        return Wearing.isHoldingJetpack(player) ? player.field_71071_by.func_70448_g() : null;
    }

    public static boolean isHoldingHose(EntityPlayer player) {
        return player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemHose;
    }

    public static ItemStack getHoldingHose(EntityPlayer player) {
        return Wearing.isHoldingHose(player) ? player.field_71071_by.func_70448_g() : null;
    }

    public static boolean isWearingHat(EntityPlayer player) {
        return player.field_71071_by.field_70460_b[3] != null && player.field_71071_by.field_70460_b[3].func_77973_b() instanceof ItemAdventureHat;
    }

    public static ItemStack getWearingHat(EntityPlayer player) {
        return Wearing.isWearingHat(player) ? player.field_71071_by.field_70460_b[3] : null;
    }

    public static boolean isWearingBoots(EntityPlayer player) {
        return player.field_71071_by.field_70460_b[0] != null && player.field_71071_by.field_70460_b[0].func_77973_b() instanceof ItemPistonBoots;
    }

    public static ItemStack getWearingBoots(EntityPlayer player) {
        return Wearing.isWearingBoots(player) ? player.field_71071_by.field_70460_b[0] : null;
    }

    public static enum WearableType {
        BACKPACK,
        COPTERPACK,
        JETPACK,
        UNKNOWN;


        public static WearableType get(@Nonnull ItemStack stack) {
            Item item = stack.func_77973_b();
            if (item == ModItems.adventureBackpack) {
                return BACKPACK;
            }
            if (item == ModItems.copterPack) {
                return COPTERPACK;
            }
            if (item == ModItems.coalJetpack) {
                return JETPACK;
            }
            return UNKNOWN;
        }
    }
}

