/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.me;

import appeng.api.AEApi;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IDisplayRepo;
import appeng.api.storage.data.IItemList;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.core.AEConfig;
import appeng.items.storage.ItemViewCell;
import appeng.util.prioitylist.IPartitionList;
import com.glodblock.github.api.FluidCraftAPI;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.util.FluidSorters;
import com.glodblock.github.util.Util;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class FluidRepo
implements IDisplayRepo {
    protected final IItemList<IAEItemStack> list = AEApi.instance().storage().createItemList();
    protected final ArrayList<IAEItemStack> view = new ArrayList();
    protected final ArrayList<ItemStack> dsp = new ArrayList();
    protected final IScrollSource src;
    protected final ISortSource sortSrc;
    protected int rowSize = 9;
    protected String searchString = "";
    protected IPartitionList<IAEItemStack> myPartitionList;
    protected boolean paused = false;
    private String NEIWord = null;
    private boolean hasPower;

    public FluidRepo(IScrollSource src, ISortSource sortSrc) {
        this.src = src;
        this.sortSrc = sortSrc;
    }

    public IAEItemStack getReferenceItem(int idx) {
        if ((idx += this.src.getCurrentScroll() * this.rowSize) >= this.view.size()) {
            return null;
        }
        return this.view.get(idx);
    }

    public ItemStack getItem(int idx) {
        if ((idx += this.src.getCurrentScroll() * this.rowSize) >= this.dsp.size()) {
            return null;
        }
        return this.dsp.get(idx);
    }

    public void postUpdate(IAEItemStack is) {
        IAEItemStack st = (IAEItemStack)this.list.findPrecise((IAEStack)is);
        if (st != null) {
            st.reset();
            st.add(is);
        } else {
            this.list.add((IAEStack)is);
        }
    }

    public void setViewCell(ItemStack[] list) {
        this.myPartitionList = ItemViewCell.createFilter((ItemStack[])list);
        this.updateView();
    }

    public void updateView() {
        if (this.paused) {
            for (int i = 0; i < this.view.size(); ++i) {
                IAEItemStack entry = this.view.get(i);
                IAEItemStack serverEntry = (IAEItemStack)this.list.findPrecise((IAEStack)entry);
                if (serverEntry == null) {
                    entry.setStackSize(0L);
                    continue;
                }
                this.view.set(i, serverEntry);
            }
            HashSet<IAEItemStack> viewSet = new HashSet<IAEItemStack>(this.view);
            ArrayList<IAEItemStack> entriesToAdd = new ArrayList<IAEItemStack>();
            for (IAEItemStack serverEntry : this.list) {
                if (viewSet.contains(serverEntry)) continue;
                entriesToAdd.add(serverEntry);
            }
            this.addEntriesToView(entriesToAdd);
        } else {
            this.view.clear();
            this.view.ensureCapacity(this.list.size());
            this.addEntriesToView((Iterable<IAEItemStack>)this.list);
        }
        if (!this.paused) {
            Enum SortBy = this.sortSrc.getSortBy();
            Enum SortDir2 = this.sortSrc.getSortDir();
            FluidSorters.setDirection((SortDir)SortDir2);
            FluidSorters.init();
            if (SortBy == SortOrder.MOD) {
                this.view.sort(FluidSorters.CONFIG_BASED_SORT_BY_MOD);
            } else if (SortBy == SortOrder.AMOUNT) {
                this.view.sort(FluidSorters.CONFIG_BASED_SORT_BY_SIZE);
            } else if (SortBy == SortOrder.INVTWEAKS) {
                this.view.sort(FluidSorters.CONFIG_BASED_SORT_BY_INV_TWEAKS);
            } else {
                this.view.sort(FluidSorters.CONFIG_BASED_SORT_BY_NAME);
            }
        }
        this.dsp.clear();
        this.dsp.ensureCapacity(this.list.size());
        for (IAEItemStack is : this.view) {
            this.dsp.add(is.getItemStack());
        }
    }

    private void addEntriesToView(Iterable<IAEItemStack> entries) {
        Pattern m;
        Enum viewMode = this.sortSrc.getSortDisplay();
        Enum searchMode = AEConfig.instance.settings.getSetting(Settings.SEARCH_MODE);
        if (searchMode == SearchBoxMode.NEI_AUTOSEARCH || searchMode == SearchBoxMode.NEI_MANUAL_SEARCH) {
            this.updateNEI(this.searchString);
        }
        String innerSearch = this.searchString;
        boolean searchMod = false;
        if (innerSearch.startsWith("@")) {
            searchMod = true;
            innerSearch = innerSearch.substring(1);
        }
        try {
            m = Pattern.compile(innerSearch.toLowerCase(), 2);
        }
        catch (Throwable ignore) {
            try {
                m = Pattern.compile(Pattern.quote(innerSearch.toLowerCase()), 2);
            }
            catch (Throwable __) {
                return;
            }
        }
        for (IAEItemStack is : entries) {
            if (this.myPartitionList != null && !this.myPartitionList.isListed((IAEStack)is) || viewMode == ViewItems.CRAFTABLE && !is.isCraftable()) continue;
            if (viewMode == ViewItems.CRAFTABLE) {
                is = is.copy();
                is.setStackSize(0L);
            }
            if (viewMode == ViewItems.STORED && is.getStackSize() == 0L) continue;
            Fluid fluid = ItemFluidDrop.getAeFluidStack(is).getFluid();
            if (FluidCraftAPI.instance().isBlacklistedInDisplay(fluid.getClass())) continue;
            if (searchMod) {
                if (!m.matcher(Util.getFluidModID(fluid).toLowerCase()).find() && !m.matcher(Util.getFluidModName(fluid).toLowerCase()).find()) continue;
                this.view.add(is);
                continue;
            }
            if (!m.matcher(fluid.getLocalizedName().toLowerCase()).find()) continue;
            this.view.add(is);
        }
    }

    protected void updateNEI(String filter) {
        try {
            if (this.NEIWord == null || !this.NEIWord.equals(filter)) {
                Class c = ReflectionHelper.getClass((ClassLoader)this.getClass().getClassLoader(), (String[])new String[]{"codechicken.nei.LayoutManager"});
                Field fldSearchField = c.getField("searchField");
                Object searchField = fldSearchField.get(c);
                Method a = searchField.getClass().getMethod("setText", String.class);
                Method b = searchField.getClass().getMethod("onTextChange", String.class);
                this.NEIWord = filter;
                a.invoke(searchField, filter);
                b.invoke(searchField, "");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int size() {
        return this.view.size();
    }

    public void clear() {
        this.list.resetStatus();
    }

    public boolean hasPower() {
        return this.hasPower;
    }

    public void setPowered(boolean hasPower) {
        this.hasPower = hasPower;
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public void setRowSize(int rowSize) {
        this.rowSize = rowSize;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(@Nonnull String searchString) {
        this.searchString = searchString;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        if (this.paused != paused) {
            this.paused = paused;
            if (!paused) {
                this.updateView();
            }
        }
    }
}

