/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.coremod.transform;

import com.glodblock.github.coremod.FCClassTransformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class CraftingTreeNodeTransformer
extends FCClassTransformer.ClassMapper {
    public static final CraftingTreeNodeTransformer INSTANCE = new CraftingTreeNodeTransformer();

    private CraftingTreeNodeTransformer() {
    }

    @Override
    protected ClassVisitor getClassMapper(ClassVisitor downstream) {
        return new TransformCraftingTreeNode(327680, downstream);
    }

    private static class TransformCraftingTreeNode
    extends ClassVisitor {
        TransformCraftingTreeNode(int api, ClassVisitor cv) {
            super(api, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (name.equals("request")) {
                return new TransformRequest(this.api, super.visitMethod(access, name, desc, signature, exceptions));
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
    }

    private static class TransformRequest
    extends MethodVisitor {
        private boolean writingBytes = false;
        private int cnt = 0;

        TransformRequest(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (opcode == 180 && owner.equals("appeng/crafting/CraftingTreeNode") && name.equals("bytes")) {
                this.writingBytes = true;
            }
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        public void visitLineNumber(int line, Label start) {
            this.writingBytes = false;
            super.visitLineNumber(line, start);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (this.writingBytes && opcode == 185 && owner.equals("appeng/api/storage/data/IAEItemStack") && name.equals("getStackSize")) {
                this.writingBytes = false;
                ++this.cnt;
                super.visitMethodInsn(184, "com/glodblock/github/coremod/hooker/CoreModHooks", "getCraftingByteCost", "(Lappeng/api/storage/data/IAEItemStack;)J", false);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }

        public void visitInsn(int opcode) {
            if (this.writingBytes && this.cnt == 5 && opcode == 97) {
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "appeng/crafting/CraftingTreeNode", "what", "Lappeng/api/storage/data/IAEItemStack;");
                super.visitMethodInsn(184, "com/glodblock/github/coremod/hooker/CoreModHooks", "getFluidDropsByteCost", "(JJLappeng/api/storage/data/IAEItemStack;)J", false);
                this.writingBytes = false;
                ++this.cnt;
                return;
            }
            super.visitInsn(opcode);
        }
    }
}

