/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.crossmod.extracells.storage;

import appeng.api.AEApi;
import appeng.api.exceptions.AppEngException;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.util.item.AEFluidStack;
import com.glodblock.github.common.storage.FluidCellInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class ProxyFluidCellInventory
extends FluidCellInventory {
    private static final String EC_CONVERTED = "ecc";

    public ProxyFluidCellInventory(ItemStack o, ISaveProvider container) throws AppEngException {
        super(o, container);
    }

    @Override
    protected void loadCellFluids() {
        if (!this.tagCompound.func_74764_b(EC_CONVERTED)) {
            if (this.cellFluids == null) {
                this.cellFluids = AEApi.instance().storage().createFluidList();
            }
            this.cellFluids.resetStatus();
            for (int i = 0; i < this.cellType.getTotalTypes(this.cellItem); ++i) {
                FluidStack fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)this.tagCompound.func_74775_l("Fluid#" + i));
                this.tagCompound.func_82580_o("Fluid#" + i);
                AEFluidStack aet = AEFluidStack.create((Object)fs);
                if (aet == null || aet.getStackSize() <= 0L) continue;
                this.cellFluids.add((IAEStack)aet);
            }
            this.tagCompound.func_74757_a(EC_CONVERTED, true);
            long fluidCount = 0L;
            int x = 0;
            for (IAEFluidStack v : this.cellFluids) {
                fluidCount += v.getStackSize();
                NBTBase c = this.tagCompound.func_74781_a(fluidSlots[x]);
                if (c instanceof NBTTagCompound) {
                    v.writeToNBT((NBTTagCompound)c);
                } else {
                    NBTTagCompound g = new NBTTagCompound();
                    v.writeToNBT(g);
                    this.tagCompound.func_74782_a(fluidSlots[x], (NBTBase)g);
                }
                this.tagCompound.func_74772_a(fluidSlotCount[x], v.getStackSize());
                ++x;
            }
            this.storedFluids = (short)this.cellFluids.size();
            if (!this.cellFluids.isEmpty()) {
                this.tagCompound.func_74777_a("ft", this.storedFluids);
            }
            this.storedFluidCount = fluidCount;
            if (fluidCount > 0L) {
                this.tagCompound.func_74772_a("fc", fluidCount);
            }
        } else {
            super.loadCellFluids();
        }
    }
}

