/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import appeng.api.storage.data.IAEFluidStack;
import appeng.util.item.AEFluidStack;
import com.glodblock.github.client.gui.container.ContainerFluidMonitor;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;

public class CPacketFluidUpdate
implements IMessage {
    private IAEFluidStack fluid;
    private boolean shift;
    private int slotIndex;

    public CPacketFluidUpdate() {
    }

    public CPacketFluidUpdate(int slotIndex) {
        this(null, slotIndex, true);
    }

    public CPacketFluidUpdate(IAEFluidStack fluid, boolean shift) {
        this(fluid, -1, shift);
    }

    private CPacketFluidUpdate(IAEFluidStack fluid, int slotIndex, boolean shift) {
        this.fluid = fluid;
        this.slotIndex = slotIndex;
        this.shift = shift;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.fluid = buf.readBoolean() ? AEFluidStack.loadFluidStackFromPacket((ByteBuf)buf) : null;
            this.slotIndex = buf.readInt();
            this.shift = buf.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        try {
            if (this.fluid == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                this.fluid.writeToPacket(buf);
            }
            buf.writeInt(this.slotIndex);
            buf.writeBoolean(this.shift);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class Handler
    implements IMessageHandler<CPacketFluidUpdate, IMessage> {
        public IMessage onMessage(CPacketFluidUpdate message, MessageContext ctx) {
            Container container = ctx.getServerHandler().field_147369_b.field_71070_bA;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (container instanceof ContainerFluidMonitor) {
                ((ContainerFluidMonitor)container).postChange(message.fluid, (EntityPlayer)player, message.slotIndex, message.shift);
            }
            return null;
        }
    }
}

