/*
 * Decompiled with CFR 0.152.
 */
package vazkii.akashictome;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import vazkii.akashictome.ConfigHandler;
import vazkii.akashictome.ModItems;
import vazkii.akashictome.MorphingHandler;
import vazkii.akashictome.utils.ItemNBTHelper;

public class AttachementRecipe
implements IRecipe {
    public boolean func_77569_a(InventoryCrafting var1, World var2) {
        boolean foundTool = false;
        boolean foundTarget = false;
        ItemStack tome = null;
        ItemStack tool = null;
        for (int i = 0; i < var1.func_70302_i_(); ++i) {
            ItemStack stack = var1.func_70301_a(i);
            if (stack != null && MorphingHandler.isAkashicTome(stack)) {
                tome = stack;
            } else if (stack != null) {
                tool = stack;
            }
            if (stack == null) continue;
            if (this.isTarget(stack)) {
                if (foundTarget) {
                    return false;
                }
                foundTarget = true;
                continue;
            }
            if (stack.func_77973_b() == ModItems.tome) {
                if (foundTool) {
                    return false;
                }
                foundTool = true;
                continue;
            }
            return false;
        }
        if (tome != null && tool != null) {
            String registryName = tool.func_77973_b().delegate.name();
            if (MorphingHandler.containsItem(tome, tool) && !ConfigHandler.whitelistedDuplicatesItems.contains(registryName + ":" + tool.func_77960_j()) && !ConfigHandler.whitelistedDuplicatesItems.contains(registryName + ":*")) {
                foundTarget = false;
            }
        }
        return foundTool && foundTarget;
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        String mod;
        ItemStack tool = null;
        ItemStack target = null;
        for (int i = 0; i < var1.func_70302_i_(); ++i) {
            ItemStack stack = var1.func_70301_a(i);
            if (stack == null) continue;
            if (stack.func_77973_b() == ModItems.tome) {
                tool = stack;
                continue;
            }
            target = stack;
        }
        ItemStack copy = tool.func_77946_l();
        NBTTagCompound cmp = copy.func_77978_p();
        if (cmp == null) {
            cmp = new NBTTagCompound();
            copy.func_77982_d(cmp);
        }
        if (!cmp.func_74764_b("akashictome:data")) {
            cmp.func_74782_a("akashictome:data", (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound morphData = cmp.func_74775_l("akashictome:data");
        String modClean = mod = MorphingHandler.getModFromStack(target);
        int iter = 1;
        while (morphData.func_74764_b(mod)) {
            mod = modClean + iter;
            ++iter;
        }
        ItemNBTHelper.setString(target, "akashictome:definedMod", mod);
        morphData.func_74782_a(mod, (NBTBase)ItemNBTHelper.saveItemStackToNBT(target));
        return copy;
    }

    public boolean isTarget(ItemStack stack) {
        if (stack == null || MorphingHandler.isAkashicTome(stack)) {
            return false;
        }
        String mod = MorphingHandler.getModFromStack(stack);
        if (mod.equals("minecraft")) {
            return false;
        }
        if (ConfigHandler.allItems) {
            return true;
        }
        if (ConfigHandler.blacklistedMods.contains(mod) || mod.equals("akashictome")) {
            return false;
        }
        String registryName = stack.func_77973_b().delegate.name();
        if (ConfigHandler.blacklistedItems.contains(registryName) || ConfigHandler.blacklistedItems.contains(registryName + ":" + stack.func_77960_j())) {
            return false;
        }
        if (ConfigHandler.whitelistedItems.contains(registryName) || ConfigHandler.whitelistedItems.contains(registryName + ":" + stack.func_77960_j())) {
            return true;
        }
        String itemName = registryName.toLowerCase() + ":" + stack.func_77960_j();
        for (String s : ConfigHandler.whitelistedNames) {
            if (!itemName.contains(s.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public int func_77570_a() {
        return 10;
    }

    public ItemStack func_77571_b() {
        return null;
    }
}

