/*
 * Decompiled with CFR 0.152.
 */
package vazkii.akashictome.utils;

import codechicken.nei.PositionedStack;
import cpw.mods.fml.common.registry.GameData;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class ItemNBTHelper {
    public static boolean detectNBT(ItemStack stack) {
        return stack.func_77942_o();
    }

    public static void initNBT(ItemStack stack) {
        if (!ItemNBTHelper.detectNBT(stack)) {
            ItemNBTHelper.injectNBT(stack, new NBTTagCompound());
        }
    }

    public static void injectNBT(ItemStack stack, NBTTagCompound nbt) {
        stack.func_77982_d(nbt);
    }

    public static NBTTagCompound getNBT(ItemStack stack) {
        ItemNBTHelper.initNBT(stack);
        return stack.func_77978_p();
    }

    public static void setBoolean(ItemStack stack, String tag, boolean b) {
        ItemNBTHelper.getNBT(stack).func_74757_a(tag, b);
    }

    public static void setByte(ItemStack stack, String tag, byte b) {
        ItemNBTHelper.getNBT(stack).func_74774_a(tag, b);
    }

    public static void setShort(ItemStack stack, String tag, short s) {
        ItemNBTHelper.getNBT(stack).func_74777_a(tag, s);
    }

    public static void setInt(ItemStack stack, String tag, int i) {
        ItemNBTHelper.getNBT(stack).func_74768_a(tag, i);
    }

    public static void setLong(ItemStack stack, String tag, long l) {
        ItemNBTHelper.getNBT(stack).func_74772_a(tag, l);
    }

    public static void setFloat(ItemStack stack, String tag, float f) {
        ItemNBTHelper.getNBT(stack).func_74776_a(tag, f);
    }

    public static void setDouble(ItemStack stack, String tag, double d) {
        ItemNBTHelper.getNBT(stack).func_74780_a(tag, d);
    }

    public static void setCompound(ItemStack stack, String tag, NBTTagCompound cmp) {
        if (!tag.equalsIgnoreCase("ench")) {
            ItemNBTHelper.getNBT(stack).func_74782_a(tag, (NBTBase)cmp);
        }
    }

    public static void setString(ItemStack stack, String tag, String s) {
        ItemNBTHelper.getNBT(stack).func_74778_a(tag, s);
    }

    public static void setList(ItemStack stack, String tag, NBTTagList list) {
        ItemNBTHelper.getNBT(stack).func_74782_a(tag, (NBTBase)list);
    }

    public static boolean verifyExistance(ItemStack stack, String tag) {
        return stack != null && ItemNBTHelper.getNBT(stack).func_74764_b(tag);
    }

    public static boolean getBoolean(ItemStack stack, String tag, boolean defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? ItemNBTHelper.getNBT(stack).func_74767_n(tag) : defaultExpected;
    }

    public static byte getByte(ItemStack stack, String tag, byte defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? ItemNBTHelper.getNBT(stack).func_74771_c(tag) : defaultExpected;
    }

    public static short getShort(ItemStack stack, String tag, short defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? ItemNBTHelper.getNBT(stack).func_74765_d(tag) : defaultExpected;
    }

    public static int getInt(ItemStack stack, String tag, int defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? ItemNBTHelper.getNBT(stack).func_74762_e(tag) : defaultExpected;
    }

    public static long getLong(ItemStack stack, String tag, long defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? ItemNBTHelper.getNBT(stack).func_74763_f(tag) : defaultExpected;
    }

    public static float getFloat(ItemStack stack, String tag, float defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? ItemNBTHelper.getNBT(stack).func_74760_g(tag) : defaultExpected;
    }

    public static double getDouble(ItemStack stack, String tag, double defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? ItemNBTHelper.getNBT(stack).func_74769_h(tag) : defaultExpected;
    }

    public static NBTTagCompound getCompound(ItemStack stack, String tag, boolean nullifyOnFail) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? ItemNBTHelper.getNBT(stack).func_74775_l(tag) : (nullifyOnFail ? null : new NBTTagCompound());
    }

    public static String getString(ItemStack stack, String tag, String defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? ItemNBTHelper.getNBT(stack).func_74779_i(tag) : defaultExpected;
    }

    public static NBTTagList getList(ItemStack stack, String tag, int objtype, boolean nullifyOnFail) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? ItemNBTHelper.getNBT(stack).func_150295_c(tag, objtype) : (nullifyOnFail ? null : new NBTTagList());
    }

    public static boolean areStacksSameTypeWithNBT(ItemStack stack1, ItemStack stack2) {
        return stack1 != null && stack2 != null && stack1.func_77973_b() == stack2.func_77973_b() && (!stack2.func_77981_g() || stack2.func_77960_j() == stack1.func_77960_j()) && ItemNBTHelper.matchTag((NBTBase)stack1.func_77978_p(), (NBTBase)stack2.func_77978_p());
    }

    public static boolean areStacksSameTypeCraftingWithNBT(ItemStack stack1, ItemStack stack2) {
        return stack1 != null && stack2 != null && stack1.func_77973_b() == stack2.func_77973_b() && (stack1.func_77960_j() == stack2.func_77960_j() || stack1.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == Short.MAX_VALUE || stack1.func_77973_b().func_77645_m()) && ItemNBTHelper.matchTag((NBTBase)stack1.func_77978_p(), (NBTBase)stack2.func_77978_p());
    }

    public static boolean matchTag(@Nullable NBTBase template, @Nullable NBTBase target) {
        if (template instanceof NBTTagCompound && target instanceof NBTTagCompound) {
            return ItemNBTHelper.matchTagCompound((NBTTagCompound)template, (NBTTagCompound)target);
        }
        if (template instanceof NBTTagList && target instanceof NBTTagList) {
            return ItemNBTHelper.matchTagList((NBTTagList)template, (NBTTagList)target);
        }
        return template == null || target != null && target.equals((Object)template);
    }

    private static boolean matchTagCompound(NBTTagCompound template, NBTTagCompound target) {
        if (template.field_74784_a.size() > target.field_74784_a.size()) {
            return false;
        }
        for (String key : template.func_150296_c()) {
            if (ItemNBTHelper.matchTag(template.func_74781_a(key), target.func_74781_a(key))) continue;
            return false;
        }
        return true;
    }

    private static boolean matchTagList(NBTTagList template, NBTTagList target) {
        if (template.func_74745_c() > target.func_74745_c()) {
            return false;
        }
        for (int i = 0; i < template.func_74745_c(); ++i) {
            if (ItemNBTHelper.matchTag(ItemNBTHelper.get(template, i), ItemNBTHelper.get(target, i))) continue;
            return false;
        }
        return true;
    }

    private static NBTBase get(NBTTagList tag, int idx) {
        return idx >= 0 && idx < tag.field_74747_a.size() ? (NBTBase)tag.field_74747_a.get(idx) : null;
    }

    public static boolean cachedRecipeContainsWithNBT(Collection<PositionedStack> ingredients, ItemStack ingredient) {
        for (PositionedStack stack : ingredients) {
            if (!ItemNBTHelper.positionedStackContainsWithNBT(stack, ingredient)) continue;
            return true;
        }
        return false;
    }

    public static boolean positionedStackContainsWithNBT(PositionedStack stack, ItemStack ingredient) {
        for (ItemStack item : stack.items) {
            if (!ItemNBTHelper.areStacksSameTypeCraftingWithNBT(item, ingredient)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack loadItemStackFromNBT(NBTTagCompound nbt) {
        String name = nbt.func_74779_i("name");
        if (name == null) {
            return null;
        }
        Item item = (Item)GameData.getItemRegistry().func_82594_a(name);
        if (item == null) {
            return null;
        }
        byte size = nbt.func_74771_c("Count");
        short meta = nbt.func_74765_d("Damage");
        ItemStack stack = new ItemStack(item, (int)size, (int)meta);
        if (nbt.func_150297_b("tag", 10)) {
            stack.field_77990_d = nbt.func_74775_l("tag");
        }
        return stack;
    }

    public static NBTTagCompound saveItemStackToNBT(ItemStack stack) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("name", stack.func_77973_b().delegate.name());
        nbt.func_74774_a("Count", (byte)stack.field_77994_a);
        nbt.func_74777_a("Damage", (short)stack.func_77960_j());
        if (stack.field_77990_d != null) {
            nbt.func_74782_a("tag", (NBTBase)stack.field_77990_d);
        }
        return nbt;
    }
}

