/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies.condition;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import glowredman.amazingtrophies.ConfigHandler;
import glowredman.amazingtrophies.api.ConditionHandler;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class DeathConditionHandler
extends ConditionHandler {
    public static final String ID = "death";
    public static final String PROPERTY_SOURCES = "sources";
    public static final String PROPERTY_IS_SOURCES_ALLOW_LIST = "isSourcesAllowList";
    private final Set<DeathInfo> conditions = new HashSet<DeathInfo>();

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public void parse(String id, JsonObject json) {
        Set<String> sources = ConfigHandler.getSetProperty(json, PROPERTY_SOURCES, JsonElement::getAsString, new HashSet());
        boolean isSourcesAllowList = ConfigHandler.getBooleanProperty(json, PROPERTY_IS_SOURCES_ALLOW_LIST, false);
        DeathInfo newInfo = new DeathInfo(sources, isSourcesAllowList);
        for (DeathInfo oldInfo : this.conditions) {
            if (!newInfo.equals(oldInfo)) continue;
            oldInfo.ids.add(id);
            return;
        }
        newInfo.ids.add(id);
        this.conditions.add(newInfo);
    }

    @Override
    protected boolean isForgeEventHandler() {
        return !this.conditions.isEmpty();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDeath(LivingDeathEvent event) {
        EntityLivingBase entityLivingBase = event.entityLiving;
        if (!(entityLivingBase instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityLivingBase;
        String damageType = event.source.func_76355_l();
        for (DeathInfo condition : this.conditions) {
            condition.trigger(damageType, player);
        }
    }

    private class DeathInfo {
        private final Set<String> sources;
        private final boolean isSourcesAllowList;
        private final Set<String> ids = new HashSet<String>();

        private DeathInfo(Set<String> sources, boolean isSourcesAllowList) {
            this.sources = sources;
            this.isSourcesAllowList = isSourcesAllowList;
        }

        private void trigger(String damageType, EntityPlayer player) {
            if (this.sources.contains(damageType) ^ this.isSourcesAllowList) {
                return;
            }
            for (String id : this.ids) {
                DeathConditionHandler.this.getListener().accept(id, player);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DeathInfo)) return false;
            DeathInfo other = (DeathInfo)obj;
            if (!this.sources.equals(other.sources)) return false;
            if (this.isSourcesAllowList != other.isSourcesAllowList) return false;
            return true;
        }
    }
}

