/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.compat.mojang;

import com.gtnewhorizons.angelica.compat.mojang.Element;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public interface ParentElement
extends Element {
    public List<? extends Element> children();

    default public Optional<Element> hoveredElement(double mouseX, double mouseY) {
        for (Element element : this.children()) {
            if (!element.isMouseOver(mouseX, mouseY)) continue;
            return Optional.of(element);
        }
        return Optional.empty();
    }

    @Override
    default public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (Element element : this.children()) {
            if (!element.mouseClicked(mouseX, mouseY, button)) continue;
            this.setFocused(element);
            if (button == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    @Override
    default public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.setDragging(false);
        return this.hoveredElement(mouseX, mouseY).filter(element -> element.mouseReleased(mouseX, mouseY, button)).isPresent();
    }

    @Override
    default public boolean mouseDragged(double mouseX, double mouseY, int button) {
        return this.getFocused() != null && this.isDragging() && button == 0 && this.getFocused().mouseDragged(mouseX, mouseY, button);
    }

    public boolean isDragging();

    public void setDragging(boolean var1);

    @Override
    default public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        return this.hoveredElement(mouseX, mouseY).filter(element -> element.mouseScrolled(mouseX, mouseY, amount)).isPresent();
    }

    @Override
    default public boolean keyTyped(char typedChar, int keyCode) {
        return this.getFocused() != null && this.getFocused().keyTyped(typedChar, keyCode);
    }

    @Nullable
    public Element getFocused();

    public void setFocused(@Nullable Element var1);

    @Override
    default public boolean changeFocus(boolean lookForwards) {
        Element element2;
        Supplier<Element> supplier;
        BooleanSupplier booleanSupplier;
        Element element = this.getFocused();
        if (element != null && element.changeFocus(lookForwards)) {
            return true;
        }
        List<? extends Element> list = this.children();
        int i = list.indexOf(element);
        int j = element != null && i >= 0 ? i + (lookForwards ? 1 : 0) : (lookForwards ? 0 : list.size());
        ListIterator<? extends Element> listIterator = list.listIterator(j);
        BooleanSupplier booleanSupplier2 = lookForwards ? listIterator::hasNext : (booleanSupplier = listIterator::hasPrevious);
        Supplier<Element> supplier2 = lookForwards ? listIterator::next : (supplier = listIterator::previous);
        do {
            if (booleanSupplier.getAsBoolean()) continue;
            this.setFocused(null);
            return false;
        } while (!(element2 = supplier.get()).changeFocus(lookForwards));
        this.setFocused(element2);
        return true;
    }
}

