/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gl.compat;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkFogMode;

public class FogHelper {
    private static final float FAR_PLANE_THRESHOLD_EXP = (float)Math.log(526.3157958984375);
    private static final float FAR_PLANE_THRESHOLD_EXP2 = (float)Math.sqrt(FAR_PLANE_THRESHOLD_EXP);
    public static float red;
    public static float green;
    public static float blue;

    public static float getFogEnd() {
        return GLStateManager.getFogState().getEnd();
    }

    public static float getFogStart() {
        return GLStateManager.getFogState().getStart();
    }

    public static float getFogDensity() {
        return GLStateManager.getFogState().getDensity();
    }

    public static ChunkFogMode getFogMode() {
        ChunkFogMode chunkFogMode;
        int mode = GLStateManager.getFogState().getFogMode();
        if (mode == 0 || !GLStateManager.getFogMode().isEnabled()) {
            return ChunkFogMode.NONE;
        }
        switch (mode) {
            case 2048: 
            case 2049: {
                chunkFogMode = ChunkFogMode.EXP2;
                break;
            }
            case 9729: {
                chunkFogMode = ChunkFogMode.LINEAR;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown fog mode: " + mode);
            }
        }
        return chunkFogMode;
    }

    public static float getFogCutoff() {
        float f;
        int mode = GLStateManager.getFogState().getFogMode();
        switch (mode) {
            case 9729: {
                f = FogHelper.getFogEnd();
                break;
            }
            case 2048: {
                f = FAR_PLANE_THRESHOLD_EXP / FogHelper.getFogDensity();
                break;
            }
            case 2049: {
                f = FAR_PLANE_THRESHOLD_EXP2 / FogHelper.getFogDensity();
                break;
            }
            default: {
                f = 0.0f;
            }
        }
        return f;
    }

    public static float[] getFogColor() {
        return new float[]{red, green, blue, 1.0f};
    }
}

