/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.uniform;

import com.gtnewhorizons.angelica.glsm.RenderSystem;
import java.nio.FloatBuffer;
import java.util.function.Supplier;
import net.coderbot.iris.gl.uniform.Uniform;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.BufferUtils;

public class MatrixUniform
extends Uniform {
    private final FloatBuffer buffer = BufferUtils.createFloatBuffer((int)16);
    private Matrix4f cachedValue = null;
    private final Supplier<Matrix4f> value;

    MatrixUniform(int location, Supplier<Matrix4f> value) {
        super(location);
        this.value = value;
    }

    @Override
    public void update() {
        Matrix4f newValue = this.value.get();
        if (newValue == null) {
            throw new RuntimeException("MatrixUniform value is null");
        }
        if (!newValue.equals((Object)this.cachedValue)) {
            this.cachedValue = new Matrix4f((Matrix4fc)newValue);
            this.cachedValue.get(this.buffer);
            this.buffer.rewind();
            RenderSystem.uniformMatrix4fv(this.location, false, this.buffer);
        }
    }
}

