/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.preprocessor;

import com.gtnewhorizons.angelica.shadow.org.anarres.cpp.Feature;
import com.gtnewhorizons.angelica.shadow.org.anarres.cpp.LexerException;
import com.gtnewhorizons.angelica.shadow.org.anarres.cpp.Preprocessor;
import com.gtnewhorizons.angelica.shadow.org.anarres.cpp.StringLexerSource;
import com.gtnewhorizons.angelica.shadow.org.anarres.cpp.Token;
import net.coderbot.iris.shaderpack.StringPair;
import net.coderbot.iris.shaderpack.preprocessor.GlslCollectingListener;

public class JcppProcessor {
    public static String glslPreprocessSource(String source, Iterable<StringPair> environmentDefines) {
        if (source.contains("#warning IRIS_JCPP_GLSL_VERSION") || source.contains("#warning IRIS_JCPP_GLSL_EXTENSION")) {
            throw new RuntimeException("Some shader author is trying to exploit internal Iris implementation details, stop!");
        }
        source = source.replace("#version", "#warning IRIS_JCPP_GLSL_VERSION");
        source = source.replace("#extension", "#warning IRIS_JCPP_GLSL_EXTENSION");
        GlslCollectingListener listener = new GlslCollectingListener();
        Preprocessor pp = new Preprocessor();
        try {
            for (StringPair envDefine : environmentDefines) {
                pp.addMacro(envDefine.getKey(), envDefine.getValue());
            }
        }
        catch (LexerException e) {
            throw new RuntimeException("Unexpected LexerException processing macros", e);
        }
        pp.setListener(listener);
        pp.addInput(new StringLexerSource(source, true));
        pp.addFeature(Feature.KEEPCOMMENTS);
        StringBuilder builder = new StringBuilder();
        try {
            Token tok;
            while ((tok = pp.token()) != null && tok.getType() != 265) {
                builder.append(tok.getText());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("GLSL source pre-processing failed", e);
        }
        builder.append("\n");
        source = listener.collectLines() + builder;
        return source;
    }
}

