/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms.custom.cached;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.function.Supplier;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.parsing.MatrixType;
import net.coderbot.iris.uniforms.custom.cached.VectorCachedUniform;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL20;

public class Float4MatrixCachedUniform
extends VectorCachedUniform<Matrix4f> {
    private final FloatBuffer buffer = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();

    public Float4MatrixCachedUniform(String name, UniformUpdateFrequency updateFrequency, Supplier<Matrix4f> supplier) {
        super(name, updateFrequency, new Matrix4f(), supplier);
    }

    @Override
    protected void setFrom(Matrix4f other) {
        ((Matrix4f)this.cached).set((Matrix4fc)other);
    }

    @Override
    public void push(int location) {
        ((Matrix4f)this.cached).get(this.buffer);
        GL20.glUniformMatrix4((int)location, (boolean)false, (FloatBuffer)this.buffer);
    }

    @Override
    public MatrixType<Matrix4f> getType() {
        return MatrixType.MAT4;
    }
}

