/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.config;

public enum AccessRestriction {
    NO_ACCESS(0),
    READ(1),
    WRITE(2),
    READ_WRITE(3);

    private final int permissionBit;

    private AccessRestriction(int v) {
        this.permissionBit = v;
    }

    public boolean hasPermission(AccessRestriction ar) {
        return (this.permissionBit & ar.permissionBit) == ar.permissionBit;
    }

    public AccessRestriction restrictPermissions(AccessRestriction ar) {
        return this.getPermByBit(this.permissionBit & ar.permissionBit);
    }

    private AccessRestriction getPermByBit(int bit) {
        AccessRestriction accessRestriction;
        switch (bit) {
            default: {
                accessRestriction = NO_ACCESS;
                break;
            }
            case 1: {
                accessRestriction = READ;
                break;
            }
            case 2: {
                accessRestriction = WRITE;
                break;
            }
            case 3: {
                accessRestriction = READ_WRITE;
            }
        }
        return accessRestriction;
    }

    public AccessRestriction addPermissions(AccessRestriction ar) {
        return this.getPermByBit(this.permissionBit | ar.permissionBit);
    }

    public AccessRestriction removePermissions(AccessRestriction ar) {
        return this.getPermByBit(this.permissionBit & ~ar.permissionBit);
    }
}

