/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.block.AEBaseTileBlock;
import appeng.client.render.blocks.RenderBlockSkyCompass;
import appeng.core.features.AEFeature;
import appeng.helpers.ICustomCollision;
import appeng.tile.misc.TileSkyCompass;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSkyCompass
extends AEBaseTileBlock
implements ICustomCollision {
    public BlockSkyCompass() {
        super(Material.field_151573_f);
        this.setTileEntity(TileSkyCompass.class);
        this.isFullSize = false;
        this.isOpaque = false;
        this.field_149786_r = 0;
        this.setFeature(EnumSet.of(AEFeature.MeteoriteCompass));
    }

    @SideOnly(value=Side.CLIENT)
    protected RenderBlockSkyCompass getRenderer() {
        return new RenderBlockSkyCompass();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int direction, int metadata) {
        return Blocks.field_150339_S.func_149691_a(direction, metadata);
    }

    @Override
    public void func_149651_a(IIconRegister iconRegistry) {
    }

    @Override
    public boolean isValidOrientation(World w, int x, int y, int z, ForgeDirection forward, ForgeDirection up) {
        TileSkyCompass sc = (TileSkyCompass)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (sc != null) {
            return false;
        }
        return this.canPlaceAt(w, x, y, z, forward.getOpposite());
    }

    private boolean canPlaceAt(World w, int x, int y, int z, ForgeDirection dir) {
        return w.isSideSolid(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir.getOpposite(), false);
    }

    public void func_149695_a(World w, int x, int y, int z, Block id) {
        TileSkyCompass sc = (TileSkyCompass)this.getTileEntity((IBlockAccess)w, x, y, z);
        ForgeDirection up = sc.getForward();
        if (!this.canPlaceAt(w, x, y, z, up.getOpposite())) {
            this.dropTorch(w, x, y, z);
        }
    }

    private void dropTorch(World w, int x, int y, int z) {
        w.func_147480_a(x, y, z, true);
        w.func_147471_g(x, y, z);
    }

    public boolean func_149742_c(World w, int x, int y, int z) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.canPlaceAt(w, x, y, z, dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<AxisAlignedBB> getSelectedBoundingBoxesFromPool(World w, int x, int y, int z, Entity e, boolean isVisual) {
        TileSkyCompass tile = (TileSkyCompass)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (tile != null) {
            ForgeDirection forward = tile.getForward();
            double minX = 0.0;
            double minY = 0.0;
            double minZ = 0.0;
            double maxX = 1.0;
            double maxY = 1.0;
            double maxZ = 1.0;
            switch (forward) {
                case DOWN: {
                    minX = 0.3125;
                    minZ = 0.3125;
                    maxX = 0.6875;
                    maxZ = 0.6875;
                    maxY = 1.0;
                    minY = 0.875;
                    break;
                }
                case EAST: {
                    minY = 0.3125;
                    minZ = 0.3125;
                    maxY = 0.6875;
                    maxZ = 0.6875;
                    maxX = 0.125;
                    minX = 0.0;
                    break;
                }
                case NORTH: {
                    minX = 0.3125;
                    minY = 0.3125;
                    maxX = 0.6875;
                    maxY = 0.6875;
                    maxZ = 1.0;
                    minZ = 0.875;
                    break;
                }
                case SOUTH: {
                    minX = 0.3125;
                    minY = 0.3125;
                    maxX = 0.6875;
                    maxY = 0.6875;
                    maxZ = 0.125;
                    minZ = 0.0;
                    break;
                }
                case UP: {
                    minX = 0.3125;
                    minZ = 0.3125;
                    maxX = 0.6875;
                    maxZ = 0.6875;
                    maxY = 0.125;
                    minY = 0.0;
                    break;
                }
                case WEST: {
                    minY = 0.3125;
                    minZ = 0.3125;
                    maxY = 0.6875;
                    maxZ = 0.6875;
                    maxX = 1.0;
                    minX = 0.875;
                    break;
                }
            }
            return Collections.singletonList(AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        }
        return Collections.singletonList(AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
    }

    public void addCollidingBlockToList(World w, int x, int y, int z, AxisAlignedBB bb, List out, Entity e) {
    }
}

