/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.api.AEApi;
import appeng.api.config.TerminalFontSize;
import appeng.api.storage.IItemDisplayRegistry;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.AEBaseGui;
import appeng.client.render.StackSizeRenderer;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class AppEngRenderItem
extends RenderItem {
    public AEBaseGui parent;
    private IAEItemStack aeStack = null;
    private static final ItemStack PATTERN = (ItemStack)AEApi.instance().definitions().items().encodedPattern().maybeStack(1).orNull();
    public static List<IItemDisplayRegistry.ItemRenderHook> POST_HOOKS = new ArrayList<IItemDisplayRegistry.ItemRenderHook>();

    public void func_94148_a(FontRenderer fontRenderer, TextureManager textureManager, ItemStack is, int par4, int par5, String par6Str) {
        if (is != null) {
            boolean isCraftable;
            boolean skip = false;
            boolean showDurabilitybar = true;
            boolean showStackSize = true;
            boolean showCraftLabelText = true;
            for (IItemDisplayRegistry.ItemRenderHook hook : POST_HOOKS) {
                skip |= hook.renderOverlay(fontRenderer, textureManager, is, par4, par5);
                showDurabilitybar &= hook.showDurability(is);
                showStackSize &= hook.showStackSize(is);
                showCraftLabelText &= hook.showCraftLabelText(is);
            }
            if (skip) {
                return;
            }
            boolean unicodeFlag = fontRenderer.func_82883_a();
            TerminalFontSize fontSize = AEConfig.instance.getTerminalFontSize();
            fontRenderer.func_78264_a(false);
            if (showDurabilitybar && is.func_77973_b().showDurabilityBar(is)) {
                double health = is.func_77973_b().getDurabilityForDisplay(is);
                int j1 = (int)Math.round(13.0 - health * 13.0);
                int k = (int)Math.round(255.0 - health * 255.0);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)3553);
                GL11.glDisable((int)3008);
                GL11.glDisable((int)3042);
                Tessellator tessellator = Tessellator.field_78398_a;
                int l = 255 - k << 16 | k << 8;
                int i1 = (255 - k) / 4 << 16 | 0x3F00;
                this.func_77017_a(tessellator, par4 + 2, par5 + 13, 13, 2, 0);
                this.func_77017_a(tessellator, par4 + 2, par5 + 13, 12, 1, i1);
                this.func_77017_a(tessellator, par4 + 2, par5 + 13, j1, 1, l);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)3553);
                GL11.glEnable((int)2896);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (showCraftLabelText && this.aeStack != null && this.aeStack.isCraftable()) {
                if (is.field_77994_a == 0) {
                    String craftLabelText = fontSize == TerminalFontSize.SMALL ? GuiText.SmallFontCraft.getLocal() : GuiText.LargeFontCraft.getLocal();
                    GL11.glDisable((int)2896);
                    GL11.glPushMatrix();
                    StackSizeRenderer.drawStackSize(par4, par5, craftLabelText, fontRenderer, fontSize);
                    GL11.glPopMatrix();
                    GL11.glEnable((int)2896);
                } else if (this.parent != null) {
                    GL11.glDisable((int)2896);
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.4f, (float)0.4f, (float)0.4f);
                    this.parent.drawItem((int)((double)(par4 + 10) * 2.5), (int)((double)par5 * 2.5), PATTERN);
                    GL11.glScalef((float)2.5f, (float)2.5f, (float)2.5f);
                    GL11.glPopMatrix();
                    GL11.glEnable((int)2896);
                }
            }
            long amount = this.aeStack != null ? this.aeStack.getStackSize() : (long)is.field_77994_a;
            boolean bl = isCraftable = this.aeStack != null && this.aeStack.isCraftable();
            if (showStackSize && (amount > 0L || !isCraftable)) {
                GL11.glDisable((int)2896);
                GL11.glPushMatrix();
                StackSizeRenderer.drawStackSize(par4, par5, amount, fontRenderer, fontSize);
                GL11.glPopMatrix();
                GL11.glEnable((int)2896);
            }
            fontRenderer.func_78264_a(unicodeFlag);
        }
    }

    public IAEItemStack getAeStack() {
        return this.aeStack;
    }

    public void setAeStack(@Nonnull IAEItemStack aeStack) {
        this.aeStack = aeStack;
    }
}

