/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.api.util.DimensionalCoord;
import appeng.me.helpers.AENetworkProxy;
import appeng.parts.p2p.PartP2PSound;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.ref.WeakReference;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;

public final class SoundEventHandler {
    public static final SoundEventHandler INSTANCE = new SoundEventHandler();
    private final Multimap<DimensionalCoord, PartP2PSound> loadedP2Ps = HashMultimap.create((int)32, (int)1);
    private boolean inSoundEvent = false;

    private SoundEventHandler() {
    }

    public void activateP2P(PartP2PSound p2p) {
        AENetworkProxy proxy = p2p.getProxy();
        if (proxy == null) {
            return;
        }
        DimensionalCoord coord = proxy.getLocation();
        coord.add(p2p.getSide(), 1);
        this.loadedP2Ps.put((Object)coord, (Object)p2p);
    }

    public void deactivateP2P(PartP2PSound p2p) {
        AENetworkProxy proxy = p2p.getProxy();
        if (proxy == null) {
            return;
        }
        DimensionalCoord coord = proxy.getLocation();
        coord.add(p2p.getSide(), 1);
        this.loadedP2Ps.remove((Object)coord, (Object)p2p);
    }

    public Collection<PartP2PSound> getTunnelsAround(DimensionalCoord soundPosition) {
        return this.loadedP2Ps.get((Object)soundPosition);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.world.field_72995_K) {
            return;
        }
        event.world.func_72954_a((IWorldAccess)new SoundProxyAccess(event.world));
    }

    public class SoundProxyAccess
    implements IWorldAccess {
        private final WeakReference<World> world;

        public SoundProxyAccess(World world) {
            this.world = new WeakReference<World>(world);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void func_72702_a(String recordName, int x, int y, int z) {
            if (SoundEventHandler.this.inSoundEvent) {
                return;
            }
            SoundEventHandler.this.inSoundEvent = true;
            try {
                World w = (World)this.world.get();
                if (w == null) {
                    return;
                }
                DimensionalCoord position = new DimensionalCoord(w, x, y, z);
                Collection p2ps = SoundEventHandler.this.loadedP2Ps.get((Object)position);
                p2ps.forEach(p2p -> p2p.proxyCall((outPos, outWorld) -> outWorld.func_72934_a(recordName, outPos.x, outPos.y, outPos.z)));
            }
            finally {
                SoundEventHandler.this.inSoundEvent = false;
            }
        }

        public void func_82746_a(int soundId, int x, int y, int z, int extraData) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void func_72706_a(EntityPlayer optionalPlayer, int soundId, int x, int y, int z, int extraData) {
            if (SoundEventHandler.this.inSoundEvent) {
                return;
            }
            SoundEventHandler.this.inSoundEvent = true;
            try {
                World w = (World)this.world.get();
                if (w == null) {
                    return;
                }
                DimensionalCoord position = new DimensionalCoord(w, x, y, z);
                Collection p2ps = SoundEventHandler.this.loadedP2Ps.get((Object)position);
                p2ps.forEach(p2p -> p2p.proxyCall((outPos, outWorld) -> outWorld.func_72926_e(soundId, outPos.x, outPos.y, outPos.z, extraData)));
            }
            finally {
                SoundEventHandler.this.inSoundEvent = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void func_72704_a(String soundName, double dx, double dy, double dz, float volume, float pitch) {
            if (SoundEventHandler.this.inSoundEvent) {
                return;
            }
            SoundEventHandler.this.inSoundEvent = true;
            try {
                int x = (int)Math.floor(dx);
                int y = (int)Math.floor(dy);
                int z = (int)Math.floor(dz);
                World w = (World)this.world.get();
                if (w == null) {
                    return;
                }
                DimensionalCoord position = new DimensionalCoord(w, x, y, z);
                Collection p2ps = SoundEventHandler.this.loadedP2Ps.get((Object)position);
                p2ps.forEach(p2p -> p2p.proxyCall((outPos, outWorld) -> outWorld.func_72908_a((double)outPos.x, (double)outPos.y, (double)outPos.z, soundName, volume, pitch)));
            }
            finally {
                SoundEventHandler.this.inSoundEvent = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void func_85102_a(EntityPlayer srcPlayer, String soundName, double dx, double dy, double dz, float volume, float pitch) {
            if (SoundEventHandler.this.inSoundEvent) {
                return;
            }
            SoundEventHandler.this.inSoundEvent = true;
            try {
                int x = (int)Math.floor(dx);
                int y = (int)Math.floor(dy);
                int z = (int)Math.floor(dz);
                World w = (World)this.world.get();
                if (w == null) {
                    return;
                }
                DimensionalCoord position = new DimensionalCoord(w, x, y, z);
                Collection p2ps = SoundEventHandler.this.loadedP2Ps.get((Object)position);
                p2ps.forEach(p2p -> p2p.proxyCall((outPos, outWorld) -> outWorld.func_72908_a((double)outPos.x, (double)outPos.y, (double)outPos.z, soundName, volume, pitch)));
            }
            finally {
                SoundEventHandler.this.inSoundEvent = false;
            }
        }

        public void func_147586_a(int p_147586_1_, int p_147586_2_, int p_147586_3_) {
        }

        public void func_147588_b(int p_147588_1_, int p_147588_2_, int p_147588_3_) {
        }

        public void func_147585_a(int p_147585_1_, int p_147585_2_, int p_147585_3_, int p_147585_4_, int p_147585_5_, int p_147585_6_) {
        }

        public void func_72708_a(String p_72708_1_, double p_72708_2_, double p_72708_4_, double p_72708_6_, double p_72708_8_, double p_72708_10_, double p_72708_12_) {
        }

        public void func_72703_a(Entity p_72703_1_) {
        }

        public void func_72709_b(Entity p_72709_1_) {
        }

        public void func_147587_b(int p_147587_1_, int p_147587_2_, int p_147587_3_, int p_147587_4_, int p_147587_5_) {
        }

        public void func_147584_b() {
        }
    }
}

