/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.AEApi;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridCache;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridStorage;
import appeng.api.networking.IMachineSet;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkPostCacheConstruction;
import appeng.api.util.IReadOnlyCollection;
import appeng.core.AEConfig;
import appeng.core.worlddata.WorldData;
import appeng.hooks.TickHandler;
import appeng.me.GridNode;
import appeng.me.GridNodeCollection;
import appeng.me.GridStorage;
import appeng.me.MachineSet;
import appeng.me.NetworkEventBus;
import appeng.me.NetworkList;
import appeng.me.cache.CraftingGridCache;
import appeng.parts.misc.PartStorageBus;
import appeng.util.ReadOnlyCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class Grid
implements IGrid {
    private final UUID id;
    private final NetworkEventBus eventBus = new NetworkEventBus();
    private final Map<Class<? extends IGridHost>, MachineSet> machines = new HashMap<Class<? extends IGridHost>, MachineSet>();
    private final Map<Class<? extends IGridCache>, IGridCache> caches = new HashMap<Class<? extends IGridCache>, IGridCache>();
    private GridNode pivot;
    private int priority;
    private GridStorage myStorage;
    private int[] timeStatistics = null;
    private static final int PROFILING_SAMPLE_COUNT = 200;
    private int timeStatisticsIndex = 0;
    private boolean profilingPassedFullCycle = false;

    public Grid(GridNode center) {
        this.pivot = center;
        this.id = UUID.randomUUID();
        HashMap<Class<? extends IGridCache>, IGridCache> myCaches = AEApi.instance().registries().gridCache().createCacheInstance(this);
        for (Map.Entry c : myCaches.entrySet()) {
            Class key = (Class)c.getKey();
            IGridCache value = (IGridCache)c.getValue();
            Class<?> valueClass = value.getClass();
            this.eventBus.readClass(key, valueClass);
            this.caches.put(key, value);
        }
        this.postEvent(new MENetworkPostCacheConstruction());
        TickHandler.INSTANCE.addNetwork(this);
        center.setGrid(this);
    }

    int getPriority() {
        return this.priority;
    }

    IGridStorage getMyStorage() {
        return this.myStorage;
    }

    Map<Class<? extends IGridCache>, IGridCache> getCaches() {
        return this.caches;
    }

    public Iterable<Class<? extends IGridHost>> getMachineClasses() {
        return this.machines.keySet();
    }

    int size() {
        int out = 0;
        for (Collection collection : this.machines.values()) {
            out += collection.size();
        }
        return out;
    }

    void remove(GridNode gridNode) {
        for (IGridCache c : this.caches.values()) {
            IGridHost machine = gridNode.getMachine();
            c.removeNode(gridNode, machine);
        }
        Class<? extends IGridHost> machineClass = gridNode.getMachineClass();
        Set nodes = this.machines.get(machineClass);
        if (nodes != null) {
            nodes.remove(gridNode);
        }
        gridNode.setGridStorage(null);
        if (this.pivot == gridNode) {
            Iterator n = this.getNodes().iterator();
            if (n.hasNext()) {
                this.pivot = (GridNode)n.next();
            } else {
                this.pivot = null;
                TickHandler.INSTANCE.removeNetwork(this);
                this.myStorage.remove();
            }
        }
    }

    void add(GridNode gridNode) {
        Class<? extends IGridHost> mClass = gridNode.getMachineClass();
        MachineSet nodes = this.machines.get(mClass);
        if (nodes == null) {
            nodes = new MachineSet(mClass);
            this.machines.put(mClass, nodes);
            this.eventBus.readClass(mClass, mClass);
        }
        if (gridNode.getGridStorage() != null) {
            GridStorage gs = gridNode.getGridStorage();
            IGrid grid = gs.getGrid();
            if (grid == null) {
                this.myStorage = gs;
                this.myStorage.setGrid(this);
                for (IGridCache gc : this.caches.values()) {
                    gc.onJoin(this.myStorage);
                }
            } else if (grid != this) {
                if (this.myStorage == null) {
                    this.myStorage = WorldData.instance().storageData().getNewGridStorage();
                    this.myStorage.setGrid(this);
                }
                GridStorage tmp = new GridStorage();
                if (!gs.hasDivided(this.myStorage)) {
                    gs.addDivided(this.myStorage);
                    for (IGridCache gc : ((Grid)grid).caches.values()) {
                        gc.onSplit(tmp);
                    }
                    for (IGridCache gc : this.caches.values()) {
                        gc.onJoin(tmp);
                    }
                }
            }
        } else if (this.myStorage == null) {
            this.myStorage = WorldData.instance().storageData().getNewGridStorage();
            this.myStorage.setGrid(this);
        }
        gridNode.setGridStorage(this.myStorage);
        nodes.add(gridNode);
        for (IGridCache cache : this.caches.values()) {
            IGridHost machine = gridNode.getMachine();
            cache.addNode(gridNode, machine);
        }
        gridNode.getGridProxy().gridChanged();
    }

    @Override
    public <C extends IGridCache> C getCache(Class<? extends IGridCache> iface) {
        return (C)this.caches.get(iface);
    }

    @Override
    public MENetworkEvent postEvent(MENetworkEvent ev) {
        CraftingGridCache.pauseRebuilds();
        MENetworkEvent ret = this.eventBus.postEvent(this, ev);
        CraftingGridCache.unpauseRebuilds();
        return ret;
    }

    @Override
    public MENetworkEvent postEventTo(IGridNode node, MENetworkEvent ev) {
        return this.eventBus.postEventTo(this, (GridNode)node, ev);
    }

    @Override
    public IReadOnlyCollection<Class<? extends IGridHost>> getMachinesClasses() {
        Set<Class<? extends IGridHost>> machineKeys = this.machines.keySet();
        return new ReadOnlyCollection<Class<? extends IGridHost>>((Collection<Class<? extends IGridHost>>)machineKeys);
    }

    @Override
    public IMachineSet getMachines(Class<? extends IGridHost> c) {
        MachineSet s = this.machines.get(c);
        if (s == null) {
            return new MachineSet(c);
        }
        return s;
    }

    @Override
    public IReadOnlyCollection<IGridNode> getNodes() {
        return new GridNodeCollection(this.machines);
    }

    @Override
    public boolean isEmpty() {
        return this.pivot == null;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public IGridNode getPivot() {
        return this.pivot;
    }

    void setPivot(GridNode pivot) {
        this.pivot = pivot;
    }

    public void startProfiling() {
        this.timeStatistics = new int[200];
        this.profilingPassedFullCycle = false;
    }

    public int stopProfiling() {
        if (this.timeStatistics == null) {
            return 0;
        }
        long sum = 0L;
        int N = this.profilingPassedFullCycle ? 200 : this.timeStatisticsIndex;
        for (int i = 0; i < N; ++i) {
            sum += (long)this.timeStatistics[i];
        }
        this.timeStatistics = null;
        return (int)(sum / (long)N);
    }

    public boolean isProfiling() {
        return this.timeStatistics != null;
    }

    public void update() {
        long time = 0L;
        if (this.isProfiling()) {
            time = System.nanoTime();
        }
        for (IGridCache gc : this.caches.values()) {
            if (this.pivot == null) continue;
            gc.onUpdateTick();
        }
        if (this.isProfiling()) {
            ++this.timeStatisticsIndex;
            if (this.timeStatisticsIndex == 200) {
                this.profilingPassedFullCycle = true;
                this.timeStatisticsIndex = 0;
            }
            this.timeStatistics[this.timeStatisticsIndex] = (int)(System.nanoTime() - time);
        }
    }

    void saveState() {
        for (IGridCache c : this.caches.values()) {
            c.populateGridStorage(this.myStorage);
        }
    }

    public void setImportantFlag(int i, boolean publicHasPower) {
        int flag = 1 << i;
        this.priority = this.priority & ~flag | (publicHasPower ? flag : 0);
    }

    public boolean equals(Object o) {
        if (o instanceof Grid) {
            Grid grid = (Grid)o;
            return this.id.equals(grid.id);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    @Override
    public NetworkList getGridConnections(Class<? extends IGridHost> accessType) {
        NetworkList result = new NetworkList();
        result.add(this);
        HashMap<IGridHost, IGrid> gridConnections = this.getSubnetGridMap(accessType);
        for (Map.Entry<IGridHost, IGrid> entry : gridConnections.entrySet()) {
            if (!accessType.isInstance(entry.getKey()) || result.contains((Grid)entry.getValue())) continue;
            result.add((Grid)entry.getValue());
        }
        return result;
    }

    @Override
    public NetworkList getAllRecursiveGridConnections(Class<? extends IGridHost> accessType) {
        if (accessType == null) {
            return null;
        }
        return this.getAllRecursiveGridConnections(accessType, new HashSet<UUID>(), 0);
    }

    private HashMap<IGridHost, IGrid> getSubnetGridMap(Class<? extends IGridHost> accessType) {
        IMachineSet storageBuses = this.getMachines(PartStorageBus.class);
        HashMap<IGridHost, IGrid> gridConnections = new HashMap<IGridHost, IGrid>();
        for (IGridNode bus : storageBuses) {
            PartStorageBus sb;
            IGrid connectedGrid;
            IGridHost iGridHost = bus.getMachine();
            if (!(iGridHost instanceof PartStorageBus) || (connectedGrid = (sb = (PartStorageBus)iGridHost).getConnectedGrid()) == null) continue;
            gridConnections.put(sb, sb.getConnectedGrid());
        }
        return gridConnections;
    }

    private NetworkList getAllRecursiveGridConnections(Class<? extends IGridHost> accessType, Set<UUID> visited, int depth) {
        NetworkList result = this.getGridConnections(accessType);
        if (depth > AEConfig.instance.maxRecursiveDepth) {
            return result;
        }
        HashMap<IGridHost, IGrid> gridConnections = this.getSubnetGridMap(accessType);
        for (Map.Entry<IGridHost, IGrid> entry : gridConnections.entrySet()) {
            Grid innerGrid;
            if (!accessType.isInstance(entry.getKey()) || (innerGrid = (Grid)entry.getValue()) == null || visited.contains(innerGrid.getId())) continue;
            visited.add(innerGrid.getId());
            if (!result.contains(innerGrid)) {
                result.add(innerGrid);
            }
            NetworkList subResult = innerGrid.getAllRecursiveGridConnections(accessType, visited, ++depth);
            result.mergeDistinct(subResult);
        }
        return result;
    }
}

