/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.layers;

import appeng.api.parts.IPart;
import appeng.api.parts.LayerBase;
import appeng.parts.layers.InvLayerData;
import appeng.parts.layers.InvSot;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class LayerISidedInventory
extends LayerBase
implements ISidedInventory {
    private static final int[] NULL_SIDES = new int[0];
    private InvLayerData invLayer = null;

    @Override
    public void notifyNeighbors() {
        ArrayList<ISidedInventory> inventories = new ArrayList<ISidedInventory>();
        int slotCount = 0;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            IPart bp = this.getPart(side);
            if (!(bp instanceof ISidedInventory)) continue;
            ISidedInventory part = (ISidedInventory)bp;
            slotCount += part.func_70302_i_();
            inventories.add(part);
        }
        ArrayList<Object> slots = null;
        int[][] sideData = null;
        if (inventories.isEmpty() || slotCount == 0) {
            inventories = null;
        } else {
            sideData = new int[][]{NULL_SIDES, NULL_SIDES, NULL_SIDES, NULL_SIDES, NULL_SIDES, NULL_SIDES};
            slots = new ArrayList<Object>(Collections.nCopies(slotCount, null));
            int offsetForLayer = 0;
            int offsetForPart = 0;
            for (ISidedInventory sides : inventories) {
                offsetForPart = 0;
                slotCount = sides.func_70302_i_();
                ForgeDirection currentSide = ForgeDirection.UNKNOWN;
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    if (this.getPart(side) != sides) continue;
                    currentSide = side;
                    break;
                }
                int[] nArray = new int[slotCount];
                sideData[currentSide.ordinal()] = nArray;
                int[] cSidesList = nArray;
                for (int cSlot = 0; cSlot < slotCount; ++cSlot) {
                    cSidesList[cSlot] = offsetForLayer;
                    slots.set(offsetForLayer, new InvSot(sides, offsetForPart));
                    ++offsetForLayer;
                    ++offsetForPart;
                }
            }
        }
        this.invLayer = sideData == null || slots == null ? null : new InvLayerData(sideData, inventories, slots);
        super.notifyNeighbors();
    }

    public int func_70302_i_() {
        if (this.invLayer == null) {
            return 0;
        }
        return this.invLayer.getSizeInventory();
    }

    public ItemStack func_70301_a(int slot) {
        if (this.invLayer == null) {
            return null;
        }
        return this.invLayer.getStackInSlot(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.invLayer == null) {
            return null;
        }
        return this.invLayer.decreaseStackSize(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        if (this.invLayer == null) {
            return;
        }
        this.invLayer.setInventorySlotContents(slot, itemstack);
    }

    public String func_145825_b() {
        return "AEMultiPart";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        if (this.invLayer == null) {
            return false;
        }
        return this.invLayer.isItemValidForSlot(slot, itemstack);
    }

    public void func_70296_d() {
        if (this.invLayer != null) {
            this.invLayer.markDirty();
        }
        super.markForSave();
    }

    public int[] func_94128_d(int side) {
        if (this.invLayer != null) {
            return this.invLayer.getAccessibleSlotsFromSide(side);
        }
        return NULL_SIDES;
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        if (this.invLayer == null) {
            return false;
        }
        return this.invLayer.canInsertItem(slot, itemstack, side);
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        if (this.invLayer == null) {
            return false;
        }
        return this.invLayer.canExtractItem(slot, itemstack, side);
    }
}

