/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.PartItemStack;
import appeng.client.texture.CableBusTextures;
import appeng.core.AEConfig;
import appeng.core.localization.PlayerMessages;
import appeng.me.GridAccessException;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.parts.AEBasePart;
import appeng.parts.PartBasicState;
import com.google.common.base.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class PartP2PTunnel<T extends PartP2PTunnel>
extends PartBasicState {
    private final TunnelCollection type = new TunnelCollection(null, this.getClass());
    public boolean output;
    public long freq;

    public PartP2PTunnel(ItemStack is) {
        super(is);
    }

    public TunnelCollection<T> getCollection(Collection<PartP2PTunnel> collection, Class<? extends PartP2PTunnel> c) {
        if (this.type.matches(c)) {
            this.type.setSource(collection);
            return this.type;
        }
        return null;
    }

    public T getInput() {
        if (this.getFrequency() == 0L) {
            return null;
        }
        try {
            PartP2PTunnel tunnel = this.getProxy().getP2P().getInput(this.getFrequency());
            if (this.getClass().isInstance(tunnel)) {
                return (T)tunnel;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return null;
    }

    public TunnelCollection<T> getOutputs() throws GridAccessException {
        if (this.getProxy().isActive()) {
            return this.getProxy().getP2P().getOutputs(this.getFrequency(), this.getClass());
        }
        return new TunnelCollection(new ArrayList(), this.getClass());
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 13.0);
        bch.addBox(3.0, 3.0, 13.0, 13.0, 13.0, 14.0);
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setTexture(this.getTypeTexture());
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        rh.setTexture(CableBusTextures.PartTunnelSides.getIcon(), CableBusTextures.PartTunnelSides.getIcon(), CableBusTextures.BlockP2PTunnel2.getIcon(), this.getItemStack().func_77954_c(), CableBusTextures.PartTunnelSides.getIcon(), CableBusTextures.PartTunnelSides.getIcon());
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderInventoryBox(renderer);
    }

    public IIcon getTypeTexture() {
        Optional<Block> maybeBlock = AEApi.instance().definitions().blocks().quartz().maybeBlock();
        if (maybeBlock.isPresent()) {
            return ((Block)maybeBlock.get()).func_149691_a(0, 0);
        }
        return Blocks.field_150371_ca.func_149691_a(0, 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        this.setRenderCache(rh.useSimplifiedRendering(x, y, z, this, this.getRenderCache()));
        rh.setTexture(this.getTypeTexture());
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(CableBusTextures.PartTunnelSides.getIcon(), CableBusTextures.PartTunnelSides.getIcon(), CableBusTextures.BlockP2PTunnel2.getIcon(), this.getItemStack().func_77954_c(), CableBusTextures.PartTunnelSides.getIcon(), CableBusTextures.PartTunnelSides.getIcon());
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(3.0f, 3.0f, 13.0f, 13.0f, 13.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(CableBusTextures.BlockP2PTunnel3.getIcon());
        rh.setBounds(6.0f, 5.0f, 12.0f, 10.0f, 11.0f, 13.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(5.0f, 6.0f, 12.0f, 11.0f, 10.0f, 13.0f);
        rh.renderBlock(x, y, z, renderer);
        this.renderLights(x, y, z, rh, renderer);
    }

    @Override
    public ItemStack getItemStack(PartItemStack type) {
        if (type == PartItemStack.World || type == PartItemStack.Network || type == PartItemStack.Wrench || type == PartItemStack.Pick) {
            return super.getItemStack(type);
        }
        Optional<ItemStack> maybeMEStack = AEApi.instance().definitions().parts().p2PTunnelME().maybeStack(1);
        if (maybeMEStack.isPresent()) {
            return (ItemStack)maybeMEStack.get();
        }
        return super.getItemStack(type);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.setOutput(data.func_74767_n("output"));
        this.setFrequency(data.func_74763_f("freq"));
    }

    public NBTTagCompound getMemoryCardData() {
        NBTTagCompound output = new NBTTagCompound();
        if (this.hasCustomName()) {
            NBTTagCompound dsp = new NBTTagCompound();
            dsp.func_74778_a("Name", this.getCustomName());
            output.func_74782_a("display", (NBTBase)dsp);
        }
        output.func_74772_a("freq", this.getFrequency());
        ItemStack p2pItem = this.getItemStack(PartItemStack.Wrench);
        p2pItem.func_77955_b(output);
        return output;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("output", this.isOutput());
        data.func_74772_a("freq", this.getFrequency());
    }

    @Override
    public int cableConnectionRenderTo() {
        return 1;
    }

    @Override
    public boolean useStandardMemoryCard() {
        return false;
    }

    @Override
    public abstract boolean onPartActivate(EntityPlayer var1, Vec3 var2);

    protected void printConnectionInfo(EntityPlayer player) {
        if (this.isOutput()) {
            T input = this.getInput();
            if (input == null) {
                player.func_145747_a(PlayerMessages.TunnelNotConnected.toChat());
            } else {
                TileEntity t = ((AEBasePart)input).getTile();
                player.func_145747_a((IChatComponent)new ChatComponentTranslation(PlayerMessages.TunnelInputIsAt.getUnlocalized(), new Object[]{t.field_145851_c, t.field_145848_d, t.field_145849_e}));
            }
        } else {
            try {
                TunnelCollection<T> oo = this.getOutputs();
                if (oo.isEmpty()) {
                    player.func_145747_a(PlayerMessages.TunnelHasNoOutputs.toChat());
                } else {
                    player.func_145747_a(PlayerMessages.TunnelOutputsAreAt.toChat());
                    for (PartP2PTunnel t : oo) {
                        TileEntity te = t.getTile();
                        if (te == null) continue;
                        player.func_145747_a((IChatComponent)new ChatComponentText("(" + te.field_145851_c + ", " + te.field_145848_d + ", " + te.field_145849_e + ")"));
                    }
                }
            }
            catch (GridAccessException ignored) {
                player.func_145747_a(PlayerMessages.TunnelNotConnected.toChat());
            }
        }
    }

    @Override
    public boolean onPartShiftActivate(EntityPlayer player, Vec3 pos) {
        Item item;
        ItemStack is = player.field_71071_by.func_70448_g();
        if (is != null && (item = is.func_77973_b()) instanceof IMemoryCard) {
            IMemoryCard mc = (IMemoryCard)item;
            if (ForgeEventFactory.onItemUseStart((EntityPlayer)player, (ItemStack)is, (int)1) <= 0) {
                return false;
            }
            PartP2PTunnel<?> tunnel = this.convertToInput(player, null);
            tunnel.saveInputToMemoryCard(player, mc, is);
            return true;
        }
        return false;
    }

    public PartP2PTunnel<?> convertToInput(EntityPlayer player, ItemStack newType) {
        if (newType != null && !this.canChangeType(newType)) {
            return null;
        }
        if (this.isOutput() || this.getFrequency() == 0L) {
            ItemStack itemStack = newType == null ? this.getItemStack(PartItemStack.Wrench) : newType;
            PartP2PTunnel<?> newTunnel = this.replacePartInWorld(player, itemStack);
            newTunnel.setOutput(false);
            long freq = System.currentTimeMillis();
            super.updateFreq(freq);
            newTunnel.copySettings(this);
            this.configureNewTunnel(newTunnel);
            return newTunnel;
        }
        return this;
    }

    public PartP2PTunnel<?> convertToOutput(EntityPlayer player, ItemStack newType, long freq) {
        if (!this.canChangeType(newType) || freq == 0L) {
            return null;
        }
        PartP2PTunnel<?> newTunnel = this.replacePartInWorld(player, newType);
        newTunnel.setOutput(true);
        super.updateFreq(freq);
        Object input = newTunnel.getInput();
        newTunnel.copyMeta((PartP2PTunnel<?>)input);
        newTunnel.copySettings((PartP2PTunnel<?>)input);
        this.configureNewTunnel(newTunnel);
        return newTunnel;
    }

    public PartP2PTunnel<?> unbind(EntityPlayer player) {
        if (this.getFrequency() == 0L) {
            return this;
        }
        ItemStack itemStack = this.getItemStack(PartItemStack.Wrench);
        PartP2PTunnel<?> newTunnel = this.replacePartInWorld(player, itemStack);
        newTunnel.setOutput(false);
        super.updateFreq(0L);
        this.configureNewTunnel(newTunnel);
        return newTunnel;
    }

    private void unbindTunnel() {
        try {
            this.getProxy().getP2P().unbind(this);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void configureNewTunnel(PartP2PTunnel<?> newTunnel) {
        newTunnel.copyContents(this);
        newTunnel.onTunnelConfigChange();
        newTunnel.onTunnelNetworkChange();
    }

    protected void copyMeta(PartP2PTunnel<?> from) {
        if (from == null) {
            return;
        }
        if (from.hasCustomName()) {
            this.setCustomNameInternal(from.getCustomName());
        }
    }

    private void updateFreq(long freq) {
        try {
            this.getProxy().getP2P().updateFreq(this, freq);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    protected void saveInputToMemoryCard(EntityPlayer player, IMemoryCard mc, ItemStack is) {
        NBTTagCompound data = this.getMemoryCardData();
        ItemStack p2pItem = this.getItemStack(PartItemStack.Wrench);
        String type = p2pItem.func_77977_a();
        mc.setMemoryCardContents(is, type + ".name", data);
        mc.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
    }

    public void onTunnelConfigChange() {
    }

    public void onTunnelNetworkChange() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getBreakingTexture() {
        return CableBusTextures.BlockP2PTunnel2.getIcon();
    }

    protected void queueTunnelDrain(PowerUnits unit, double f) {
        double ae_to_tax = unit.convertTo(PowerUnits.AE, f * AEConfig.TUNNEL_POWER_LOSS);
        try {
            this.getProxy().getEnergy().extractAEPower(ae_to_tax, Actionable.MODULATE, PowerMultiplier.ONE);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public long getFrequency() {
        return this.freq;
    }

    public void setFrequency(long freq) {
        this.freq = freq;
    }

    public boolean isOutput() {
        return this.output;
    }

    void setOutput(boolean output) {
        this.output = output;
    }

    @Override
    public void setCustomName(String name) {
        T i = this.getInput();
        if (i != null) {
            ((PartP2PTunnel)i).setCustomNameInternal(name);
            try {
                for (PartP2PTunnel o : this.getOutputs()) {
                    o.setCustomNameInternal(name);
                }
            }
            catch (GridAccessException gridAccessException) {}
        } else {
            super.setCustomName(name);
        }
    }

    void setCustomNameInternal(String name) {
        super.setCustomName(name);
    }

    private boolean canChangeType(ItemStack newType) {
        if (newType == null) {
            return false;
        }
        Item item = newType.func_77973_b();
        if (item instanceof IPartItem) {
            IPartItem partItem = (IPartItem)item;
            IPart testPart = partItem.createPartFromItemStack(newType);
            return this.checkIfCompatibleType(testPart);
        }
        return false;
    }

    private PartP2PTunnel<?> replacePartInWorld(EntityPlayer player, ItemStack newType) {
        this.getHost().removePart(this.getSide(), true);
        this.unbindTunnel();
        ForgeDirection dir = this.getHost().addPart(newType, this.getSide(), player);
        IPart newBus = this.getHost().getPart(dir);
        if (newBus instanceof PartP2PTunnel) {
            PartP2PTunnel newTunnel = (PartP2PTunnel)newBus;
            return newTunnel;
        }
        throw new RuntimeException();
    }

    protected void copyContents(PartP2PTunnel<?> from) {
    }

    protected void copySettings(PartP2PTunnel<?> from) {
    }

    protected PartP2PTunnel<?> applyMemoryCard(EntityPlayer player, IMemoryCard memoryCard, ItemStack is) {
        NBTTagCompound data = memoryCard.getData(is);
        ItemStack newType = ItemStack.func_77949_a((NBTTagCompound)data);
        PartP2PTunnel<?> newTunnel = this.convertToOutput(player, newType, data.func_74763_f("freq"));
        if (newTunnel == null) {
            memoryCard.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
            return null;
        }
        memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
        return newTunnel;
    }

    protected abstract boolean checkIfCompatibleType(IPart var1);
}

