/*
 * Decompiled with CFR 0.152.
 */
package appeng.services.export;

import appeng.core.AELog;
import appeng.services.export.ExportMode;
import appeng.services.export.Exporter;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.apache.commons.io.FileUtils;

final class MinecraftItemCSVExporter
implements Exporter {
    private static final String ITEM_CSV_FILE_NAME = "items.csv";
    private static final String MINIMAL_HEADER = "Mod:Item:MetaData, Localized Name";
    private static final String VERBOSE_HEADER = "Mod:Item:MetaData, Localized Name, Unlocalized Name, Is Air?, Class Name";
    private static final String EXPORT_SUCCESSFUL_MESSAGE = "Exported successfully %d items into %s";
    private static final String EXPORT_UNSUCCESSFUL_MESSAGE = "Exporting was unsuccessful.";
    @Nonnull
    private final File exportDirectory;
    @Nonnull
    private final FMLControlledNamespacedRegistry<Item> itemRegistry;
    @Nonnull
    private final ExportMode mode;

    MinecraftItemCSVExporter(@Nonnull File exportDirectory, @Nonnull FMLControlledNamespacedRegistry<Item> itemRegistry, @Nonnull ExportMode mode) {
        this.exportDirectory = (File)Preconditions.checkNotNull((Object)exportDirectory);
        Preconditions.checkArgument((!exportDirectory.isFile() ? 1 : 0) != 0);
        this.itemRegistry = (FMLControlledNamespacedRegistry)Preconditions.checkNotNull(itemRegistry);
        this.mode = (ExportMode)((Object)Preconditions.checkNotNull((Object)((Object)mode)));
    }

    @Override
    public void export() {
        Iterable items = this.itemRegistry.typeSafeIterable();
        ArrayList itemList = Lists.newArrayList((Iterable)items);
        List lines = Lists.transform((List)itemList, (Function)new ItemRowExtractFunction(this.itemRegistry, this.mode));
        Joiner newLineJoiner = Joiner.on((char)'\n');
        Joiner newLineJoinerIgnoringNull = newLineJoiner.skipNulls();
        String joined = newLineJoinerIgnoringNull.join((Iterable)lines);
        File file = new File(this.exportDirectory, ITEM_CSV_FILE_NAME);
        try {
            FileUtils.forceMkdir((File)this.exportDirectory);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF-8")));
            String header = this.mode == ExportMode.MINIMAL ? MINIMAL_HEADER : VERBOSE_HEADER;
            writer.write(header);
            writer.write("\n");
            writer.write(joined);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            AELog.info(EXPORT_SUCCESSFUL_MESSAGE, lines.size(), ITEM_CSV_FILE_NAME);
        }
        catch (IOException e) {
            AELog.warn(EXPORT_UNSUCCESSFUL_MESSAGE, new Object[0]);
            AELog.debug(e);
        }
    }

    private static final class ItemRowExtractFunction
    implements Function<Item, String> {
        private static final String LOCALIZATION_NAME_EXTENSION = ".name";
        private static final String EXPORTING_NOTHING_MESSAGE = "Exporting nothing";
        private static final String EXPORTING_SUBTYPES_MESSAGE = "Exporting input %s with subtypes: %b";
        private static final String EXPORTING_SUBTYPES_FAILED_MESSAGE = "Could not export subtypes of: %s";
        @Nonnull
        private final FMLControlledNamespacedRegistry<Item> itemRegistry;
        @Nonnull
        private final ExportMode mode;

        ItemRowExtractFunction(@Nonnull FMLControlledNamespacedRegistry<Item> itemRegistry, @Nonnull ExportMode mode) {
            this.itemRegistry = (FMLControlledNamespacedRegistry)Preconditions.checkNotNull(itemRegistry);
            this.mode = (ExportMode)((Object)Preconditions.checkNotNull((Object)((Object)mode)));
        }

        @Nullable
        public String apply(@Nullable Item input) {
            if (!FMLCommonHandler.instance().getSide().isClient()) {
                return null;
            }
            if (input == null) {
                AELog.debug(EXPORTING_NOTHING_MESSAGE, new Object[0]);
                return null;
            }
            AELog.debug(EXPORTING_SUBTYPES_MESSAGE, input.func_77658_a(), input.func_77614_k());
            String itemName = this.itemRegistry.func_148750_c((Object)input);
            boolean hasSubtypes = input.func_77614_k();
            if (hasSubtypes) {
                CreativeTabs creativeTab = input.func_77640_w();
                ArrayList stacks = Lists.newArrayList();
                try {
                    input.func_150895_a(input, creativeTab, (List)stacks);
                }
                catch (Exception ignored) {
                    AELog.warn(EXPORTING_SUBTYPES_FAILED_MESSAGE, input.func_77658_a());
                    AELog.debug(ignored);
                    return null;
                }
                if (stacks.isEmpty()) {
                    return null;
                }
                Joiner newLineJoiner = Joiner.on((char)'\n');
                Joiner typeJoiner = newLineJoiner.skipNulls();
                List transformedTypes = Lists.transform((List)stacks, (Function)new TypeExtractFunction(itemName, this.mode));
                return typeJoiner.join((Iterable)transformedTypes);
            }
            ArrayList joinedBlockAttributes = Lists.newArrayListWithCapacity((int)5);
            String unlocalizedItem = input.func_77658_a();
            String localization = StatCollector.func_74838_a((String)(unlocalizedItem + LOCALIZATION_NAME_EXTENSION));
            joinedBlockAttributes.add(itemName);
            joinedBlockAttributes.add(localization);
            if (this.mode == ExportMode.VERBOSE) {
                Block block = Block.func_149634_a((Item)input);
                boolean isBlock = !block.equals(Blocks.field_150350_a);
                Class<?> itemClass = input.getClass();
                String itemClassName = itemClass.getName();
                joinedBlockAttributes.add(unlocalizedItem);
                joinedBlockAttributes.add(Boolean.toString(isBlock));
                joinedBlockAttributes.add(itemClassName);
            }
            Joiner csvJoiner = Joiner.on((String)", ");
            Joiner csvJoinerIgnoringNulls = csvJoiner.skipNulls();
            return csvJoinerIgnoringNulls.join((Iterable)joinedBlockAttributes);
        }
    }

    private static final class TypeExtractFunction
    implements Function<ItemStack, String> {
        private static final String EXTRACTING_NULL_MESSAGE = "extracting type null";
        private static final String EXTRACTING_ITEM_MESSAGE = "extracting type %s:%d";
        @Nonnull
        private final String itemName;
        @Nonnull
        private final ExportMode mode;

        private TypeExtractFunction(@Nonnull String itemName, @Nonnull ExportMode mode) {
            this.itemName = (String)Preconditions.checkNotNull((Object)itemName);
            Preconditions.checkArgument((!itemName.isEmpty() ? 1 : 0) != 0);
            this.mode = (ExportMode)((Object)Preconditions.checkNotNull((Object)((Object)mode)));
        }

        @Nullable
        public String apply(@Nullable ItemStack input) {
            if (input == null) {
                AELog.debug(EXTRACTING_NULL_MESSAGE, new Object[0]);
                return null;
            }
            AELog.debug(EXTRACTING_ITEM_MESSAGE, input.func_82833_r(), input.func_77960_j());
            ArrayList joinedBlockAttributes = Lists.newArrayListWithCapacity((int)5);
            int meta = input.func_77960_j();
            String metaName = this.itemName + ':' + meta;
            String localization = input.func_82833_r();
            joinedBlockAttributes.add(metaName);
            joinedBlockAttributes.add(localization);
            if (this.mode == ExportMode.VERBOSE) {
                Item item = input.func_77973_b();
                String unlocalizedItem = input.func_77977_a();
                Block block = Block.func_149634_a((Item)item);
                boolean isBlock = !block.equals(Blocks.field_150350_a);
                Class<?> stackClass = input.getClass();
                String stackClassName = stackClass.getName();
                joinedBlockAttributes.add(unlocalizedItem);
                joinedBlockAttributes.add(Boolean.toString(isBlock));
                joinedBlockAttributes.add(stackClassName);
            }
            Joiner csvJoiner = Joiner.on((String)", ");
            Joiner csvJoinerIgnoringNulls = csvJoiner.skipNulls();
            return csvJoinerIgnoringNulls.join((Iterable)joinedBlockAttributes);
        }
    }
}

