/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.gardening;

import binnie.botany.Botany;
import binnie.botany.CreativeTabBotany;
import binnie.botany.api.EnumSoilType;
import binnie.botany.api.gardening.IBlockSoil;
import binnie.botany.gardening.Gardening;
import binnie.core.util.I18N;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPlant
extends BlockBush {
    public BlockPlant() {
        this.func_149663_c("plant");
        this.func_149647_a(CreativeTabBotany.instance);
        this.func_149675_a(true);
        this.func_149672_a(Block.field_149779_h);
    }

    public static boolean isWeed(IBlockAccess world, int x, int y, int z) {
        if (!(world.func_147439_a(x, y, z) instanceof BlockPlant)) {
            return false;
        }
        Type type = Type.get(world.func_72805_g(x, y, z));
        return type == Type.Weeds || type == Type.WeedsLong || type == Type.WeedsVeryLong;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        for (Type t : Type.values()) {
            t.icon = Botany.proxy.getIcon(register, t.name().toLowerCase());
        }
    }

    protected boolean func_149854_a(Block block) {
        return super.func_149854_a(block) || Gardening.isSoil(block);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return Type.values()[meta % Type.values().length].icon;
    }

    public int func_149692_a(int damage) {
        return damage;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (Type type : Type.values()) {
            list.add(type.get());
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        Block below;
        Type type = Type.get(world.func_72805_g(x, y, z));
        if (random.nextInt(4) == 0) {
            if (type == Type.Weeds) {
                world.func_72921_c(x, y, z, Type.WeedsLong.ordinal(), 2);
            } else if (type == Type.WeedsLong) {
                world.func_72921_c(x, y, z, Type.WeedsVeryLong.ordinal(), 2);
            } else if (type == Type.DeadFlower) {
                world.func_72921_c(x, y, z, Type.DecayingFlower.ordinal(), 2);
            } else if (type == Type.DecayingFlower) {
                world.func_147468_f(x, y, z);
                return;
            }
        }
        if (random.nextInt(6) == 0) {
            if (type == Type.Weeds) {
                world.func_147468_f(x, y, z);
            } else if (type == Type.WeedsLong) {
                world.func_72921_c(x, y, z, Type.Weeds.ordinal(), 2);
            } else if (type == Type.WeedsVeryLong) {
                world.func_72921_c(x, y, z, Type.WeedsLong.ordinal(), 2);
            }
        }
        if (!Gardening.isSoil(below = world.func_147439_a(x, y - 1, z))) {
            return;
        }
        IBlockSoil soil = (IBlockSoil)below;
        if (random.nextInt(3) != 0) {
            return;
        }
        if (type == Type.Weeds || type == Type.WeedsLong || type == Type.WeedsVeryLong) {
            if (!soil.degrade(world, x, y - 1, z, EnumSoilType.LOAM)) {
                soil.degrade(world, x, y - 1, z, EnumSoilType.SOIL);
            }
        } else if (type == Type.DecayingFlower && !soil.fertilise(world, x, y - 1, z, EnumSoilType.LOAM)) {
            soil.fertilise(world, x, y - 1, z, EnumSoilType.FLOWERBED);
        }
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public static enum Type {
        Weeds("weeds"),
        WeedsLong("longWeeds"),
        WeedsVeryLong("veryLongWeeds"),
        DeadFlower("deadFlower"),
        DecayingFlower("decayingFlower");

        public IIcon icon;
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public static Type get(int id) {
            return Type.values()[id % Type.values().length];
        }

        public ItemStack get() {
            return new ItemStack((Block)Botany.plant, 1, this.ordinal());
        }

        public String getName() {
            return I18N.localise("botany.plant." + this.name);
        }
    }
}

