/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines;

import binnie.core.BinnieCore;
import binnie.core.machines.IMachine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.MachinePackage;
import binnie.core.machines.MachineUtil;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.component.IInteraction;
import binnie.core.machines.component.IRender;
import binnie.core.machines.network.INetwork;
import binnie.core.network.BinnieCorePacketID;
import binnie.core.network.INetworkedEntity;
import binnie.core.network.packet.MessageTileNBT;
import binnie.core.network.packet.PacketPayload;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import forestry.api.core.INBTTagable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class Machine
implements INetworkedEntity,
INBTTagable,
INetwork.TilePacketSync,
IMachine,
INetwork.GuiNBT {
    private final MachinePackage machinePackage;
    private final Map<Class<?>, List<MachineComponent>> componentInterfaceMap = new HashMap();
    private final Map<Class<? extends MachineComponent>, MachineComponent> componentMap = new HashMap<Class<? extends MachineComponent>, MachineComponent>();
    private final TileEntity tile;
    private boolean queuedInventoryUpdate = false;
    private GameProfile owner;
    private final MachineUtil machineUtil = new MachineUtil(this);

    public Machine(MachinePackage pack, TileEntity tile) {
        this.tile = tile;
        pack.createMachine(this);
        this.machinePackage = pack;
    }

    @Override
    public void addComponent(MachineComponent component) {
        if (component == null) {
            throw new NullPointerException("Can't have a null machine component!");
        }
        component.setMachine(this);
        this.componentMap.put(component.getClass(), component);
        for (Class<?> inter : component.getComponentInterfaces()) {
            if (!this.componentInterfaceMap.containsKey(inter)) {
                this.componentInterfaceMap.put(inter, new ArrayList());
            }
            this.componentInterfaceMap.get(inter).add(component);
        }
    }

    public Collection<MachineComponent> getComponents() {
        return this.componentMap.values();
    }

    public <T extends MachineComponent> T getComponent(Class<T> componentClass) {
        if (this.hasComponent(componentClass)) {
            return (T)((MachineComponent)componentClass.cast(this.componentMap.get(componentClass)));
        }
        return null;
    }

    @Override
    public <T> T getInterface(Class<T> cls) {
        if (this.hasInterface(cls)) {
            return (T)this.getInterfaces((Class)cls).get(0);
        }
        if (cls.isInstance(this.getPackage())) {
            return cls.cast(this.getPackage());
        }
        for (MachineComponent component : this.getComponents()) {
            if (!cls.isInstance(component)) continue;
            return cls.cast(component);
        }
        return null;
    }

    public <T> List<T> getInterfaces(Class<T> cls) {
        ArrayList<T> interfaces = new ArrayList<T>();
        if (!this.hasInterface(cls)) {
            return interfaces;
        }
        for (MachineComponent component : this.componentInterfaceMap.get(cls)) {
            interfaces.add(cls.cast(component));
        }
        return interfaces;
    }

    public boolean hasInterface(Class<?> interfaceClass) {
        return this.componentInterfaceMap.containsKey(interfaceClass);
    }

    public boolean hasComponent(Class<? extends MachineComponent> componentClass) {
        return this.componentMap.containsKey(componentClass);
    }

    @Override
    public TileEntity getTileEntity() {
        return this.tile;
    }

    public Side getSide() {
        return BinnieCore.proxy.isSimulating(this.getTileEntity().func_145831_w()) ? Side.SERVER : Side.CLIENT;
    }

    @Override
    public void writeToPacket(PacketPayload payload) {
        for (MachineComponent component : this.getComponents()) {
            if (!(component instanceof INetworkedEntity)) continue;
            INetworkedEntity ne = (INetworkedEntity)((Object)component);
            ne.writeToPacket(payload);
        }
    }

    @Override
    public void readFromPacket(PacketPayload payload) {
        for (MachineComponent component : this.getComponents()) {
            if (!(component instanceof INetworkedEntity)) continue;
            INetworkedEntity ne = (INetworkedEntity)((Object)component);
            ne.readFromPacket(payload);
        }
    }

    public void onRightClick(World world, EntityPlayer player, int x, int y, int z) {
        for (IInteraction.RightClick component : this.getInterfaces(IInteraction.RightClick.class)) {
            component.onRightClick(world, player, x, y, z);
        }
    }

    @Override
    public void markDirty() {
        this.queuedInventoryUpdate = true;
    }

    public void onUpdate() {
        if (BinnieCore.proxy.isSimulating(this.getWorld())) {
            for (MachineComponent component : this.getComponents()) {
                component.onUpdate();
            }
        } else {
            for (IRender.DisplayTick renders : this.getInterfaces(IRender.DisplayTick.class)) {
                TileEntity tileEntity = this.getTileEntity();
                renders.onDisplayTick(this.getWorld(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, this.getWorld().field_73012_v);
            }
        }
        if (this.queuedInventoryUpdate) {
            for (MachineComponent component : this.getComponents()) {
                component.onInventoryUpdate();
            }
            this.queuedInventoryUpdate = false;
        }
    }

    public IInventory getInventory() {
        return this.getInterface(IInventory.class);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        for (MachineComponent component : this.getComponents()) {
            component.readFromNBT(nbttagcompound);
        }
        this.owner = NBTUtil.func_152459_a((NBTTagCompound)nbttagcompound.func_74775_l("owner"));
        this.markDirty();
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        for (MachineComponent component : this.getComponents()) {
            component.writeToNBT(nbttagcompound);
        }
        if (this.owner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)nbt, (GameProfile)this.owner);
            nbttagcompound.func_74782_a("owner", (NBTBase)nbt);
        }
    }

    @Override
    public MachinePackage getPackage() {
        return this.machinePackage;
    }

    public static IMachine getMachine(Object inventory) {
        if (inventory instanceof IMachine) {
            IMachine m = (IMachine)inventory;
            return m;
        }
        if (inventory instanceof TileEntityMachine) {
            TileEntityMachine tem = (TileEntityMachine)inventory;
            return tem.getMachine();
        }
        if (inventory instanceof MachineComponent) {
            MachineComponent mc = (MachineComponent)inventory;
            return mc.getMachine();
        }
        return null;
    }

    public static <T> T getInterface(Class<T> interfac, Object inventory) {
        IMachine machine = Machine.getMachine(inventory);
        if (machine != null) {
            return machine.getInterface(interfac);
        }
        if (interfac.isInstance(inventory)) {
            return interfac.cast(inventory);
        }
        return null;
    }

    @Override
    public MachineUtil getMachineUtil() {
        return this.machineUtil;
    }

    @Override
    public World getWorld() {
        return this.getTileEntity().func_145831_w();
    }

    public void onBlockDestroy() {
        for (MachineComponent component : this.getComponents()) {
            component.onDestruction();
        }
    }

    @Override
    public GameProfile getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(GameProfile owner) {
        this.owner = owner;
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.syncToNBT(nbt);
        if (nbt.func_82582_d()) {
            return null;
        }
        MessageTileNBT tileNbt = new MessageTileNBT(BinnieCorePacketID.TileDescriptionSync.ordinal(), this.getTileEntity(), nbt);
        return BinnieCore.instance.getNetworkWrapper().getPacketFrom((IMessage)tileNbt.getMessage());
    }

    @Override
    public void syncToNBT(NBTTagCompound nbt) {
        for (INetwork.TilePacketSync comp : this.getInterfaces(INetwork.TilePacketSync.class)) {
            comp.syncToNBT(nbt);
        }
    }

    @Override
    public void syncFromNBT(NBTTagCompound nbt) {
        for (INetwork.TilePacketSync comp : this.getInterfaces(INetwork.TilePacketSync.class)) {
            comp.syncFromNBT(nbt);
        }
    }

    @Override
    public void receiveGuiNBT(Side side, EntityPlayer player, String name, NBTTagCompound nbt) {
        for (INetwork.ReceiveGuiNBT receive : this.getInterfaces(INetwork.ReceiveGuiNBT.class)) {
            receive.receiveGuiNBT(side, player, name, nbt);
        }
    }

    @Override
    public void sendGuiNBT(Map<String, NBTTagCompound> nbts) {
        for (INetwork.SendGuiNBT receive : this.getInterfaces(INetwork.SendGuiNBT.class)) {
            receive.sendGuiNBT(nbts);
        }
    }
}

